/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class GroupByTimeParameter {
    private long startTime;
    private long endTime;
    private long interval;
    private long slidingStep;
    private boolean isIntervalByMonth = false;
    private boolean isSlidingStepByMonth = false;
    private boolean leftCRightO;

    public GroupByTimeParameter() {
    }

    public GroupByTimeParameter(long startTime, long endTime, long interval, long slidingStep, boolean leftCRightO) {
        this(startTime, endTime, interval, slidingStep, false, false, leftCRightO);
    }

    public GroupByTimeParameter(long startTime, long endTime, long interval, long slidingStep, boolean isIntervalByMonth, boolean isSlidingStepByMonth, boolean leftCRightO) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.interval = interval;
        this.slidingStep = slidingStep;
        this.isIntervalByMonth = isIntervalByMonth;
        this.isSlidingStepByMonth = isSlidingStepByMonth;
        this.leftCRightO = leftCRightO;
    }

    public GroupByTimeParameter(GroupByTimeComponent groupByTimeComponent) {
        this.startTime = groupByTimeComponent.getStartTime();
        this.endTime = groupByTimeComponent.getEndTime();
        this.interval = groupByTimeComponent.getInterval();
        this.slidingStep = groupByTimeComponent.getSlidingStep();
        this.isIntervalByMonth = groupByTimeComponent.isIntervalByMonth();
        this.isSlidingStepByMonth = groupByTimeComponent.isSlidingStepByMonth();
        this.leftCRightO = groupByTimeComponent.isLeftCRightO();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getSlidingStep() {
        return this.slidingStep;
    }

    public void setSlidingStep(long slidingStep) {
        this.slidingStep = slidingStep;
    }

    public boolean isIntervalByMonth() {
        return this.isIntervalByMonth;
    }

    public void setIntervalByMonth(boolean intervalByMonth) {
        this.isIntervalByMonth = intervalByMonth;
    }

    public boolean isSlidingStepByMonth() {
        return this.isSlidingStepByMonth;
    }

    public void setSlidingStepByMonth(boolean slidingStepByMonth) {
        this.isSlidingStepByMonth = slidingStepByMonth;
    }

    public boolean isLeftCRightO() {
        return this.leftCRightO;
    }

    public void setLeftCRightO(boolean leftCRightO) {
        this.leftCRightO = leftCRightO;
    }

    public boolean hasOverlap() {
        return this.interval > this.slidingStep;
    }

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((long)this.startTime, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((long)this.endTime, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((long)this.interval, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((long)this.slidingStep, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((Boolean)this.isIntervalByMonth, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((Boolean)this.isSlidingStepByMonth, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((Boolean)this.leftCRightO, (ByteBuffer)buffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.startTime, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.endTime, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.interval, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.slidingStep, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isIntervalByMonth, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isSlidingStepByMonth, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.leftCRightO, (OutputStream)stream);
    }

    public static GroupByTimeParameter deserialize(ByteBuffer buffer) {
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter();
        groupByTimeParameter.setStartTime(ReadWriteIOUtils.readLong((ByteBuffer)buffer));
        groupByTimeParameter.setEndTime(ReadWriteIOUtils.readLong((ByteBuffer)buffer));
        groupByTimeParameter.setInterval(ReadWriteIOUtils.readLong((ByteBuffer)buffer));
        groupByTimeParameter.setSlidingStep(ReadWriteIOUtils.readLong((ByteBuffer)buffer));
        groupByTimeParameter.setIntervalByMonth(ReadWriteIOUtils.readBool((ByteBuffer)buffer));
        groupByTimeParameter.setSlidingStepByMonth(ReadWriteIOUtils.readBool((ByteBuffer)buffer));
        groupByTimeParameter.setLeftCRightO(ReadWriteIOUtils.readBool((ByteBuffer)buffer));
        return groupByTimeParameter;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GroupByTimeParameter)) {
            return false;
        }
        GroupByTimeParameter other = (GroupByTimeParameter)obj;
        return this.startTime == other.startTime && this.endTime == other.endTime && this.interval == other.interval && this.slidingStep == other.slidingStep && this.isSlidingStepByMonth == other.isSlidingStepByMonth && this.isIntervalByMonth == other.isIntervalByMonth && this.leftCRightO == other.leftCRightO;
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime, this.interval, this.slidingStep, this.isIntervalByMonth, this.isSlidingStepByMonth, this.leftCRightO);
    }
}

