/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.concurrent.threadpool;

import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.concurrent.ThreadPoolMetrics;
import org.apache.iotdb.commons.concurrent.WrappedCallable;
import org.apache.iotdb.commons.concurrent.WrappedRunnable;
import org.apache.iotdb.commons.concurrent.threadpool.WrappedSingleThreadScheduledExecutorMBean;
import org.apache.iotdb.commons.service.JMXService;

public class WrappedSingleThreadScheduledExecutor
implements ScheduledExecutorService,
WrappedSingleThreadScheduledExecutorMBean {
    private final String mbeanName;
    ScheduledExecutorService service;

    public WrappedSingleThreadScheduledExecutor(ScheduledExecutorService service, String mbeanName) {
        this.service = service;
        this.mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.threadpool", "type", mbeanName);
        JMXService.registerMBean(this, this.mbeanName);
        ThreadPoolMetrics.getInstance().registerThreadPool(this, this.mbeanName);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.service.schedule(WrappedRunnable.wrap(command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.service.schedule(WrappedCallable.wrap(callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.service.scheduleAtFixedRate(WrappedRunnable.wrap(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.service.scheduleWithFixedDelay(WrappedRunnable.wrap(command), initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        this.service.shutdown();
        JMXService.deregisterMBean(this.mbeanName);
    }

    @Override
    public List<Runnable> shutdownNow() {
        JMXService.deregisterMBean(this.mbeanName);
        return this.service.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.service.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.service.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.service.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.service.submit(WrappedCallable.wrap(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.service.submit(WrappedRunnable.wrap(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.service.submit(WrappedRunnable.wrap(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.service.invokeAll(tasks.stream().map(WrappedCallable::wrap).collect(Collectors.toList()));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.service.invokeAll(tasks.stream().map(WrappedCallable::wrap).collect(Collectors.toList()), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.service.invokeAny(tasks.stream().map(WrappedCallable::wrap).collect(Collectors.toList()));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.service.invokeAny(tasks.stream().map(WrappedCallable::wrap).collect(Collectors.toList()), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.service.execute(WrappedRunnable.wrap(command));
    }

    @Override
    public int getCorePoolSize() {
        return ((ThreadPoolExecutor)((Object)this.service)).getCorePoolSize();
    }

    @Override
    public boolean prestartCoreThread() {
        return ((ThreadPoolExecutor)((Object)this.service)).prestartCoreThread();
    }

    @Override
    public int getMaximumPoolSize() {
        return ((ThreadPoolExecutor)((Object)this.service)).getMaximumPoolSize();
    }

    @Override
    public Queue<Runnable> getQueue() {
        return ((ThreadPoolExecutor)((Object)this.service)).getQueue();
    }

    @Override
    public int getQueueLength() {
        return ((ThreadPoolExecutor)((Object)this.service)).getQueue().size();
    }

    @Override
    public int getPoolSize() {
        return ((ThreadPoolExecutor)((Object)this.service)).getPoolSize();
    }

    @Override
    public int getActiveCount() {
        return ((ThreadPoolExecutor)((Object)this.service)).getActiveCount();
    }

    @Override
    public int getLargestPoolSize() {
        return ((ThreadPoolExecutor)((Object)this.service)).getLargestPoolSize();
    }

    @Override
    public long getTaskCount() {
        return ((ThreadPoolExecutor)((Object)this.service)).getTaskCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return ((ThreadPoolExecutor)((Object)this.service)).getCompletedTaskCount();
    }
}

