/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.info.ganglia.gmetric4j.gmetric;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.acplt.oncrpc.XdrBufferEncodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.gmetric.AbstractProtocol;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.gmetric.GMetric;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.gmetric.GMetricSlope;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.gmetric.GMetricType;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.xdr.v31x.Ganglia_extra_data;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.xdr.v31x.Ganglia_gmetric_string;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.xdr.v31x.Ganglia_metadata_message;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.xdr.v31x.Ganglia_metadata_msg;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.xdr.v31x.Ganglia_metadatadef;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.xdr.v31x.Ganglia_metric_id;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.xdr.v31x.Ganglia_uuid;
import org.apache.ratis.thirdparty.info.ganglia.gmetric4j.xdr.v31x.Ganglia_value_msg;

public class Protocolv31x
extends AbstractProtocol {
    private static final int MAX_BUFFER_SIZE = 1024;
    private XdrBufferEncodingStream xdr = new XdrBufferEncodingStream(1024);
    private Map<String, Integer> metricCounterMap = new HashMap<String, Integer>();
    private int metadataMessageInterval;
    private UUID uuid;
    private String spoofName;
    private String localHostName;

    public Protocolv31x(String group, int port, GMetric.UDPAddressingMode mode, int ttl, int metadataMessageInterval, UUID uuid, String spoof) throws IOException {
        super(group, port, mode, ttl);
        this.metadataMessageInterval = metadataMessageInterval;
        this.uuid = uuid;
        this.spoofName = spoof;
        this.localHostName = InetAddress.getLocalHost().getHostName();
    }

    private boolean isTimeToSendMetadata(String metricName) {
        boolean ret = false;
        Integer counter = this.metricCounterMap.get(metricName);
        if (counter == null) {
            counter = 0;
            ret = true;
        } else {
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
            if (counter >= this.metadataMessageInterval) {
                counter = 0;
                ret = true;
            }
        }
        this.metricCounterMap.put(metricName, counter);
        return ret;
    }

    public void announce(String name, String value, GMetricType type, String units, GMetricSlope slope, int tmax, int dmax, String groupName) throws Exception {
        Ganglia_metric_id metric_id = new Ganglia_metric_id();
        if (this.spoofName == null) {
            metric_id.host = this.localHostName;
            metric_id.spoof = false;
        } else {
            metric_id.host = this.spoofName;
            metric_id.spoof = true;
        }
        metric_id.name = name;
        if (this.isTimeToSendMetadata(name)) {
            this.encodeGMetric(metric_id, name, value, type, units, slope, tmax, dmax, groupName);
            this.send(this.xdr.getXdrData(), this.xdr.getXdrLength());
        }
        this.encodeGValue(metric_id, value);
        this.send(this.xdr.getXdrData(), this.xdr.getXdrLength());
    }

    private void encodeGMetric(Ganglia_metric_id metric_id, String name, String value, GMetricType type, String units, GMetricSlope slope, int tmax, int dmax, String groupName) throws Exception {
        Ganglia_extra_data extra_data3;
        Ganglia_extra_data extra_data2;
        Ganglia_extra_data extra_data1;
        Ganglia_metadata_message metadata_message = new Ganglia_metadata_message();
        Ganglia_extra_data[] extra_data_array = new Ganglia_extra_data[3];
        extra_data_array[0] = extra_data1 = new Ganglia_extra_data();
        extra_data1.name = "GROUP";
        extra_data1.data = groupName;
        extra_data_array[1] = extra_data2 = new Ganglia_extra_data();
        extra_data2.name = "TITLE";
        extra_data2.data = name;
        extra_data_array[2] = extra_data3 = new Ganglia_extra_data();
        extra_data3.name = "DESC";
        extra_data3.data = name;
        metadata_message.metadata = extra_data_array;
        metadata_message.name = name;
        metadata_message.type = type.getGangliaType();
        metadata_message.units = units;
        metadata_message.slope = slope.getGangliaSlope();
        metadata_message.tmax = tmax;
        metadata_message.dmax = dmax;
        Ganglia_metadatadef metadatadef = new Ganglia_metadatadef();
        metadatadef.metric_id = metric_id;
        metadatadef.metric = metadata_message;
        Ganglia_metadata_msg metadata_msg = new Ganglia_metadata_msg();
        metadata_msg.id = 128;
        if (this.uuid != null) {
            metadata_msg.id |= 0x40;
            Ganglia_uuid _uuid = new Ganglia_uuid();
            _uuid.uuid = this.uuid;
            metadata_msg.uuid = _uuid;
        }
        metadata_msg.gfull = metadatadef;
        this.xdr.beginEncoding(this.udpAddr, this.port);
        metadata_msg.xdrEncode((XdrEncodingStream)this.xdr);
        this.xdr.endEncoding();
    }

    private void encodeGValue(Ganglia_metric_id metric_id, String value) throws Exception {
        Ganglia_value_msg value_msg = new Ganglia_value_msg();
        value_msg.id = 133;
        if (this.uuid != null) {
            value_msg.id |= 0x40;
            Ganglia_uuid _uuid = new Ganglia_uuid();
            _uuid.uuid = this.uuid;
            value_msg.uuid = _uuid;
        }
        Ganglia_gmetric_string str = new Ganglia_gmetric_string();
        str.str = value;
        str.metric_id = metric_id;
        str.fmt = "%s";
        value_msg.gstr = str;
        this.xdr.beginEncoding(this.udpAddr, this.port);
        value_msg.xdrEncode((XdrEncodingStream)this.xdr);
        this.xdr.endEncoding();
    }
}

