/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.db.exception.metadata.cache.MNodeNotCachedException;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.estimator.MNodeSizeEstimator;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.ReentrantReadOnlyCachedMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.StampedWriterPreferredLock;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.cache.CacheMemoryManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.cache.ICacheManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memcontrol.MemManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.ICachedMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.iterator.CachedTraverserIterator;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MNodeUtils;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedMTreeStore
implements IMTreeStore<ICachedMNode> {
    private static final Logger logger = LoggerFactory.getLogger(CachedMTreeStore.class);
    private final MemManager memManager;
    private final ICacheManager cacheManager;
    private ISchemaFile file;
    private ICachedMNode root;
    private final Runnable flushCallback;
    private final IMNodeFactory<ICachedMNode> nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();
    private final CachedSchemaRegionStatistics regionStatistics;
    private final StampedWriterPreferredLock lock = new StampedWriterPreferredLock();

    public CachedMTreeStore(PartialPath storageGroup, int schemaRegionId, CachedSchemaRegionStatistics regionStatistics, Runnable flushCallback) throws MetadataException, IOException {
        this.file = SchemaFile.initSchemaFile(storageGroup.getFullPath(), schemaRegionId);
        this.root = this.file.init();
        this.regionStatistics = regionStatistics;
        this.memManager = new MemManager(regionStatistics);
        this.flushCallback = flushCallback;
        this.cacheManager = CacheMemoryManager.getInstance().createLRUCacheManager(this, this.memManager);
        this.cacheManager.initRootStatus(this.root);
        regionStatistics.setCacheManager(this.cacheManager);
        this.ensureMemoryStatus();
    }

    @Override
    public ICachedMNode generatePrefix(PartialPath storageGroupPath) {
        ICachedMNode res;
        String[] nodes = storageGroupPath.getNodes();
        ICachedMNode cur = res = (ICachedMNode)this.nodeFactory.createAboveDatabaseMNode(null, nodes[0]);
        for (int i = 1; i < nodes.length - 1; ++i) {
            ICachedMNode child = (ICachedMNode)this.nodeFactory.createAboveDatabaseMNode((IMNode)cur, nodes[i]);
            cur.addChild(nodes[i], child);
            cur = child;
        }
        this.root.setParent(cur);
        cur.addChild(this.root);
        return res;
    }

    @Override
    public ICachedMNode getRoot() {
        return this.root;
    }

    @Override
    public boolean hasChild(ICachedMNode parent, String name) throws MetadataException {
        return this.hasChild(parent, name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean hasChild(ICachedMNode parent, String name, boolean needLock) throws MetadataException {
        if (needLock) {
            this.lock.threadReadLock();
        }
        try {
            ICachedMNode child = this.getChild(parent, name, needLock);
            if (child == null) {
                boolean bl = false;
                return bl;
            }
            this.unPin(child);
            boolean bl = true;
            return bl;
        }
        finally {
            if (needLock) {
                this.lock.threadReadUnlock();
            }
        }
    }

    @Override
    public ICachedMNode getChild(ICachedMNode parent, String name) throws MetadataException {
        return this.getChild(parent, name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ICachedMNode getChild(ICachedMNode parent, String name, boolean needLock) throws MetadataException {
        if (needLock) {
            this.lock.threadReadLock();
        }
        try {
            ICachedMNode node = (ICachedMNode)parent.getChild(name);
            if (node == null) {
                node = this.loadChildFromDisk(parent, name);
            } else {
                try {
                    this.cacheManager.updateCacheStatusAfterMemoryRead(node);
                }
                catch (MNodeNotCachedException e) {
                    node = this.loadChildFromDisk(parent, name);
                }
            }
            if (node != null && node.isMeasurement()) {
                this.processAlias((IDeviceMNode<ICachedMNode>)parent.getAsDeviceMNode(), (IMeasurementMNode<ICachedMNode>)node.getAsMeasurementMNode());
            }
            ICachedMNode iCachedMNode = node;
            return iCachedMNode;
        }
        finally {
            if (needLock) {
                this.lock.threadReadUnlock();
            }
        }
    }

    private ICachedMNode loadChildFromDisk(ICachedMNode parent, String name) throws MetadataException {
        ICachedMNode node = null;
        if (!ICachedMNodeContainer.getCachedMNodeContainer(parent).isVolatile()) {
            try {
                node = this.file.getChildNode(parent, name);
            }
            catch (IOException e) {
                throw new MetadataException((Throwable)e);
            }
            if (node != null) {
                node = this.loadChildFromDiskToParent(parent, node);
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICachedMNode loadChildFromDiskToParent(ICachedMNode parent, ICachedMNode node) {
        ICachedMNode iCachedMNode = parent;
        synchronized (iCachedMNode) {
            ICachedMNode nodeAlreadyLoaded = (ICachedMNode)parent.getChild(node.getName());
            if (nodeAlreadyLoaded != null) {
                try {
                    this.cacheManager.updateCacheStatusAfterMemoryRead(nodeAlreadyLoaded);
                    return nodeAlreadyLoaded;
                }
                catch (MNodeNotCachedException mNodeNotCachedException) {
                    // empty catch block
                }
            }
            node.setParent(parent);
            this.cacheManager.updateCacheStatusAfterDiskRead(node);
            this.ensureMemoryStatus();
            return node;
        }
    }

    private void processAlias(IDeviceMNode<ICachedMNode> parent, IMeasurementMNode<ICachedMNode> node) {
        String alias = node.getAlias();
        if (alias != null) {
            parent.addAlias(alias, node);
        }
    }

    @Override
    public IMNodeIterator<ICachedMNode> getChildrenIterator(ICachedMNode parent) throws MetadataException {
        return this.getChildrenIterator(parent, true);
    }

    final IMNodeIterator<ICachedMNode> getChildrenIterator(ICachedMNode parent, boolean needLock) throws MetadataException {
        try {
            return new CachedMNodeIterator(parent, needLock);
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public IMNodeIterator<ICachedMNode> getTraverserIterator(ICachedMNode parent, Map<Integer, Template> templateMap, boolean skipPreDeletedSchema) throws MetadataException {
        return this.getTraverserIterator(this, parent, templateMap, skipPreDeletedSchema);
    }

    final IMNodeIterator<ICachedMNode> getTraverserIterator(IMTreeStore<ICachedMNode> store, ICachedMNode parent, Map<Integer, Template> templateMap, boolean skipPreDeletedSchema) throws MetadataException {
        if (parent.isDevice()) {
            CachedTraverserIterator iterator = new CachedTraverserIterator(store, (IDeviceMNode<ICachedMNode>)parent.getAsDeviceMNode(), templateMap, this.nodeFactory);
            iterator.setSkipPreDeletedSchema(skipPreDeletedSchema);
            return iterator;
        }
        return store.getChildrenIterator(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedMNode addChild(ICachedMNode parent, String childName, ICachedMNode child) {
        this.lock.threadReadLock();
        try {
            child.setParent(parent);
            this.cacheManager.updateCacheStatusAfterAppend(child);
            this.ensureMemoryStatus();
            ICachedMNode iCachedMNode = (ICachedMNode)parent.getChild(childName);
            return iCachedMNode;
        }
        finally {
            this.lock.threadReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteChild(ICachedMNode parent, String childName) throws MetadataException {
        this.lock.writeLock();
        try {
            ICachedMNode deletedMNode = this.getChild(parent, childName, false);
            ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer(parent);
            if (!container.isVolatile() && !container.hasChildInNewChildBuffer(childName)) {
                try {
                    this.file.delete(deletedMNode);
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
            parent.deleteChild(childName);
            this.cacheManager.remove(deletedMNode);
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    @Override
    public void updateMNode(ICachedMNode node) {
        this.updateMNode(node, true);
    }

    final void updateMNode(ICachedMNode node, boolean needLock) {
        if (needLock) {
            this.lock.threadReadLock();
        }
        try {
            this.cacheManager.updateCacheStatusAfterUpdate(node);
        }
        finally {
            if (needLock) {
                this.lock.threadReadUnlock();
            }
        }
    }

    @Override
    public IDeviceMNode<ICachedMNode> setToEntity(ICachedMNode node) {
        IDeviceMNode<ICachedMNode> result = MNodeUtils.setToEntity(node, this.nodeFactory);
        if (result != node) {
            this.regionStatistics.addDevice();
            this.memManager.updatePinnedSize(result.estimateSize() - node.estimateSize());
        }
        this.updateMNode((ICachedMNode)result.getAsMNode());
        return result;
    }

    @Override
    public ICachedMNode setToInternal(IDeviceMNode<ICachedMNode> entityMNode) {
        ICachedMNode result = MNodeUtils.setToInternal(entityMNode, this.nodeFactory);
        if (result != entityMNode) {
            this.regionStatistics.deleteDevice();
            this.memManager.updatePinnedSize(result.estimateSize() - entityMNode.estimateSize());
        }
        this.updateMNode(result);
        return result;
    }

    @Override
    public void setAlias(IMeasurementMNode<ICachedMNode> measurementMNode, String alias) throws MetadataException {
        String existingAlias = measurementMNode.getAlias();
        if (existingAlias == null && alias == null) {
            return;
        }
        measurementMNode.setAlias(alias);
        this.updateMNode((ICachedMNode)measurementMNode.getAsMNode());
        if (existingAlias != null && alias != null) {
            this.memManager.updatePinnedSize(alias.length() - existingAlias.length());
        } else if (alias == null) {
            this.memManager.updatePinnedSize(-(MNodeSizeEstimator.getAliasBaseSize() + existingAlias.length()));
        } else {
            this.memManager.updatePinnedSize(MNodeSizeEstimator.getAliasBaseSize() + alias.length());
        }
    }

    @Override
    public void pin(ICachedMNode node) throws MetadataException {
        this.pin(node, true);
    }

    final void pin(ICachedMNode node, boolean needLock) throws MetadataException {
        if (needLock) {
            this.lock.threadReadLock();
        }
        try {
            this.cacheManager.pinMNode(node);
        }
        finally {
            if (needLock) {
                this.lock.threadReadUnlock();
            }
        }
    }

    @Override
    public void unPin(ICachedMNode node) {
        this.unPin(node, true);
    }

    final void unPin(ICachedMNode node, boolean needLock) {
        if (needLock) {
            this.lock.threadReadLock();
        }
        try {
            if (this.cacheManager.unPinMNode(node)) {
                this.ensureMemoryStatus();
            }
        }
        finally {
            if (needLock) {
                this.lock.threadReadUnlock();
            }
        }
    }

    @Override
    public void unPinPath(ICachedMNode node) {
        this.unPinPath(node, true);
    }

    public void unPinPath(ICachedMNode node, boolean needLock) {
        while (!node.isDatabase()) {
            this.unPin(node, needLock);
            node = (ICachedMNode)node.getParent();
        }
    }

    final long stampedReadLock() {
        return this.lock.stampedReadLock();
    }

    final void stampedReadUnlock(long stamp) {
        this.lock.stampedReadUnlock(stamp);
    }

    @Override
    public IMTreeStore<ICachedMNode> getWithReentrantReadLock() {
        return new ReentrantReadOnlyCachedMTreeStore(this);
    }

    @Override
    public void clear() {
        this.lock.writeLock();
        try {
            this.regionStatistics.setCacheManager(null);
            this.cacheManager.clear(this.root);
            this.root = null;
            if (this.file != null) {
                try {
                    this.file.clear();
                    this.file.close();
                }
                catch (IOException | MetadataException e) {
                    logger.error(String.format("Error occurred during PBTree clear, %s", e.getMessage()));
                }
            }
            this.file = null;
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        this.lock.writeLock();
        try {
            this.flushVolatileNodes();
            this.ensureMemoryStatus();
            boolean bl = this.file.createSnapshot(snapshotDir);
            return bl;
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    public static CachedMTreeStore loadFromSnapshot(File snapshotDir, String storageGroup, int schemaRegionId, CachedSchemaRegionStatistics regionStatistics, Runnable flushCallback) throws IOException, MetadataException {
        return new CachedMTreeStore(snapshotDir, storageGroup, schemaRegionId, regionStatistics, flushCallback);
    }

    private CachedMTreeStore(File snapshotDir, String storageGroup, int schemaRegionId, CachedSchemaRegionStatistics regionStatistics, Runnable flushCallback) throws IOException, MetadataException {
        this.file = SchemaFile.loadSnapshot(snapshotDir, storageGroup, schemaRegionId);
        this.root = this.file.init();
        this.regionStatistics = regionStatistics;
        this.memManager = new MemManager(regionStatistics);
        this.flushCallback = flushCallback;
        this.cacheManager = CacheMemoryManager.getInstance().createLRUCacheManager(this, this.memManager);
        this.cacheManager.initRootStatus(this.root);
        regionStatistics.setCacheManager(this.cacheManager);
        this.ensureMemoryStatus();
    }

    private void ensureMemoryStatus() {
        CacheMemoryManager.getInstance().ensureMemoryStatus();
    }

    public StampedWriterPreferredLock getLock() {
        return this.lock;
    }

    public CachedSchemaRegionStatistics getRegionStatistics() {
        return this.regionStatistics;
    }

    public boolean executeMemoryRelease() {
        if (this.regionStatistics.getUnpinnedMemorySize() != 0L) {
            return !this.cacheManager.evict();
        }
        return true;
    }

    public void flushVolatileNodes() {
        try {
            IDatabaseMNode<ICachedMNode> updatedStorageGroupMNode = this.cacheManager.collectUpdatedStorageGroupMNodes();
            if (updatedStorageGroupMNode != null) {
                try {
                    this.file.updateDatabaseNode(updatedStorageGroupMNode);
                }
                catch (IOException e) {
                    logger.error("IOException occurred during updating StorageGroupMNode {}", (Object)updatedStorageGroupMNode.getFullPath(), (Object)e);
                    return;
                }
            }
            List<ICachedMNode> nodesToPersist = this.cacheManager.collectVolatileMNodes();
            for (ICachedMNode volatileNode : nodesToPersist) {
                try {
                    this.file.writeMNode(volatileNode);
                }
                catch (IOException | MetadataException e) {
                    logger.error("Error occurred during MTree flush, current node is {}", (Object)volatileNode.getFullPath(), (Object)e);
                    return;
                }
                this.cacheManager.updateCacheStatusAfterPersist(volatileNode);
            }
            if (updatedStorageGroupMNode != null || !nodesToPersist.isEmpty()) {
                this.flushCallback.run();
            }
        }
        catch (Throwable e) {
            logger.error("Error occurred during MTree flush, current SchemaRegionId is {}", (Object)this.regionStatistics.getSchemaRegionId(), (Object)e);
            e.printStackTrace();
        }
    }

    private class CachedMNodeIterator
    implements IMNodeIterator<ICachedMNode> {
        ICachedMNode parent;
        Iterator<ICachedMNode> iterator;
        Iterator<ICachedMNode> bufferIterator;
        boolean isIteratingDisk;
        ICachedMNode nextNode;
        boolean isLocked;

        CachedMNodeIterator(ICachedMNode parent, boolean needLock) throws MetadataException, IOException {
            if (needLock) {
                CachedMTreeStore.this.lock.threadReadLock();
            }
            this.isLocked = true;
            try {
                this.parent = parent;
                ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer(parent);
                this.bufferIterator = container.getChildrenBufferIterator();
                if (!container.isVolatile()) {
                    this.iterator = CachedMTreeStore.this.file.getChildren(parent);
                    this.isIteratingDisk = true;
                } else {
                    this.iterator = this.bufferIterator;
                    this.isIteratingDisk = false;
                }
            }
            catch (Throwable e) {
                if (needLock) {
                    CachedMTreeStore.this.lock.threadReadUnlock();
                }
                this.isLocked = false;
                throw e;
            }
        }

        public boolean hasNext() {
            if (this.nextNode != null) {
                return true;
            }
            try {
                this.readNext();
            }
            catch (MetadataException e) {
                logger.error(String.format("Error occurred during readNext, %s", e.getMessage()));
                return false;
            }
            return this.nextNode != null;
        }

        public ICachedMNode next() {
            if (this.nextNode == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            ICachedMNode result = this.nextNode;
            this.nextNode = null;
            return result;
        }

        private void readNext() throws MetadataException {
            ICachedMNode node = null;
            if (this.isIteratingDisk) {
                ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer(this.parent);
                if (this.iterator.hasNext()) {
                    node = this.iterator.next();
                    while (container.hasChildInBuffer(node.getName())) {
                        if (this.iterator.hasNext()) {
                            node = this.iterator.next();
                            continue;
                        }
                        node = null;
                        break;
                    }
                }
                if (node != null) {
                    ICachedMNode nodeInMem = (ICachedMNode)this.parent.getChild(node.getName());
                    if (nodeInMem != null) {
                        try {
                            CachedMTreeStore.this.cacheManager.updateCacheStatusAfterMemoryRead(nodeInMem);
                            node = nodeInMem;
                        }
                        catch (MNodeNotCachedException e) {
                            node = CachedMTreeStore.this.loadChildFromDiskToParent(this.parent, node);
                        }
                    } else {
                        node = CachedMTreeStore.this.loadChildFromDiskToParent(this.parent, node);
                    }
                    this.nextNode = node;
                    return;
                }
                this.startIteratingBuffer();
            }
            if (this.iterator.hasNext()) {
                node = this.iterator.next();
                CachedMTreeStore.this.cacheManager.updateCacheStatusAfterMemoryRead(node);
            }
            this.nextNode = node;
        }

        private void startIteratingBuffer() {
            this.iterator = this.bufferIterator;
            this.isIteratingDisk = false;
        }

        public void close() {
            try {
                if (this.nextNode != null) {
                    CachedMTreeStore.this.unPin(this.nextNode);
                    this.nextNode = null;
                }
            }
            finally {
                if (this.isLocked) {
                    CachedMTreeStore.this.lock.threadReadUnlock();
                }
            }
        }
    }
}

