/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.component;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;

public class OrderByComponent
extends StatementNode {
    private final List<SortItem> sortItemList = new ArrayList<SortItem>();
    private final List<Expression> sortItemExpressionList = new ArrayList<Expression>();
    private boolean orderByTime = false;
    private int timeOrderPriority = -1;
    private boolean orderByTimeseries = false;
    private int timeseriesOrderPriority = -1;
    private boolean orderByDevice = false;
    private int deviceOrderPriority = -1;

    public void addSortItem(SortItem sortItem) {
        this.sortItemList.add(sortItem);
        switch (sortItem.getSortKey()) {
            case "TIME": {
                this.orderByTime = true;
                this.timeOrderPriority = this.sortItemList.size() - 1;
                break;
            }
            case "TIMESERIES": {
                this.orderByTimeseries = true;
                this.timeseriesOrderPriority = this.sortItemList.size() - 1;
                break;
            }
            case "DEVICE": {
                this.orderByDevice = true;
                this.deviceOrderPriority = this.sortItemList.size() - 1;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown sort key %s", sortItem.getSortKey()));
            }
        }
    }

    public boolean isUnique() {
        return this.orderByDevice && this.orderByTime;
    }

    public boolean isBasedOnDevice() {
        return this.orderByDevice && this.deviceOrderPriority == 0;
    }

    public boolean isBasedOnTime() {
        return this.orderByTime && this.timeOrderPriority == 0;
    }

    public void addExpressionSortItem(SortItem sortItem) {
        this.sortItemList.add(sortItem);
        this.sortItemExpressionList.add(ExpressionAnalyzer.toLowerCaseExpression(sortItem.getExpression()));
    }

    public List<SortItem> getSortItemList() {
        return this.sortItemList;
    }

    public List<Expression> getExpressionSortItemList() {
        return this.sortItemExpressionList;
    }

    public boolean isOrderByTime() {
        return this.orderByTime;
    }

    public Ordering getTimeOrder() {
        Preconditions.checkState((this.timeOrderPriority != -1 ? 1 : 0) != 0, (Object)"The time order is not specified.");
        return this.sortItemList.get(this.timeOrderPriority).getOrdering();
    }

    public boolean isOrderByTimeseries() {
        return this.orderByTimeseries;
    }

    public Ordering getTimeseriesOrder() {
        Preconditions.checkState((this.timeseriesOrderPriority != -1 ? 1 : 0) != 0, (Object)"The timeseries order is not specified.");
        return this.sortItemList.get(this.timeseriesOrderPriority).getOrdering();
    }

    public boolean isOrderByDevice() {
        return this.orderByDevice;
    }

    public Ordering getDeviceOrder() {
        Preconditions.checkState((this.deviceOrderPriority != -1 ? 1 : 0) != 0, (Object)"The device order is not specified.");
        return this.sortItemList.get(this.deviceOrderPriority).getOrdering();
    }

    public boolean isDeviceOrderInitialized() {
        return this.deviceOrderPriority != -1;
    }

    public boolean isTimeOrderInitialized() {
        return this.timeOrderPriority != -1;
    }

    public String toSQLString() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("ORDER BY ");
        for (int i = 0; i < this.sortItemList.size(); ++i) {
            sqlBuilder.append(this.sortItemList.get(i).toSQLString());
            if (i >= this.sortItemList.size() - 1) continue;
            sqlBuilder.append(", ");
        }
        return sqlBuilder.toString();
    }
}

