/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.confignode.rpc.thrift.TRegionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowRegionStatement;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class ShowRegionTask
implements IConfigTask {
    private final ShowRegionStatement showRegionStatement;

    public ShowRegionTask(ShowRegionStatement showRegionStatement) {
        this.showRegionStatement = showRegionStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showRegion(this.showRegionStatement);
    }

    public static void buildTSBlock(TShowRegionResp showRegionResp, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showRegionColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        if (showRegionResp.getRegionInfoList() != null) {
            for (TRegionInfo regionInfo : showRegionResp.getRegionInfoList()) {
                builder.getTimeColumnBuilder().writeLong(0L);
                builder.getColumnBuilder(0).writeInt(regionInfo.getConsensusGroupId().getId());
                if (regionInfo.getConsensusGroupId().getType().ordinal() == TConsensusGroupType.SchemaRegion.ordinal()) {
                    builder.getColumnBuilder(1).writeBinary(Binary.valueOf((String)String.valueOf(TConsensusGroupType.SchemaRegion)));
                } else if (regionInfo.getConsensusGroupId().getType().ordinal() == TConsensusGroupType.DataRegion.ordinal()) {
                    builder.getColumnBuilder(1).writeBinary(Binary.valueOf((String)String.valueOf(TConsensusGroupType.DataRegion)));
                }
                builder.getColumnBuilder(2).writeBinary(Binary.valueOf((String)(regionInfo.getStatus() == null ? "" : regionInfo.getStatus())));
                builder.getColumnBuilder(3).writeBinary(Binary.valueOf((String)regionInfo.getDatabase()));
                builder.getColumnBuilder(4).writeInt(regionInfo.getSeriesSlots());
                builder.getColumnBuilder(5).writeLong(regionInfo.getTimeSlots());
                builder.getColumnBuilder(6).writeInt(regionInfo.getDataNodeId());
                builder.getColumnBuilder(7).writeBinary(Binary.valueOf((String)regionInfo.getClientRpcIp()));
                builder.getColumnBuilder(8).writeInt(regionInfo.getClientRpcPort());
                builder.getColumnBuilder(9).writeBinary(Binary.valueOf((String)regionInfo.getRoleType()));
                builder.getColumnBuilder(10).writeBinary(new Binary(DateTimeUtils.convertLongToDate(regionInfo.getCreateTime())));
                builder.declarePosition();
            }
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowRegionHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

