/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.thrift;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.PipeRequestType;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.reponse.PipeTransferFilePieceResp;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferFilePieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferFileSealReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferHandshakeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletReq;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.IoTDBThriftConnectorRequestVersion;
import org.apache.iotdb.db.pipe.receiver.thrift.IoTDBThriftReceiver;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBThriftReceiverV1
implements IoTDBThriftReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBThriftReceiverV1.class);
    private static final IoTDBConfig IOTDB_CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final String RECEIVER_FILE_BASE_DIR = IOTDB_CONFIG.getPipeReceiverFileDir();
    private final AtomicReference<File> receiverFileDirWithIdSuffix = new AtomicReference();
    private static final AtomicLong RECEIVER_ID_GENERATOR = new AtomicLong(0L);
    private final AtomicLong receiverId = new AtomicLong(0L);
    private File writingFile;
    private RandomAccessFile writingFileWriter;

    @Override
    public synchronized TPipeTransferResp receive(TPipeTransferReq req, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        short rawRequestType = req.getType();
        if (PipeRequestType.isValidatedRequestType(rawRequestType)) {
            switch (PipeRequestType.valueOf(rawRequestType)) {
                case HANDSHAKE: {
                    return this.handleTransferHandshake(PipeTransferHandshakeReq.fromTPipeTransferReq(req));
                }
                case TRANSFER_INSERT_NODE: {
                    return this.handleTransferInsertNode(PipeTransferInsertNodeReq.fromTPipeTransferReq(req), partitionFetcher, schemaFetcher);
                }
                case TRANSFER_TABLET: {
                    return this.handleTransferTablet(PipeTransferTabletReq.fromTPipeTransferReq(req), partitionFetcher, schemaFetcher);
                }
                case TRANSFER_FILE_PIECE: {
                    return this.handleTransferFilePiece(PipeTransferFilePieceReq.fromTPipeTransferReq(req));
                }
                case TRANSFER_FILE_SEAL: {
                    return this.handleTransferFileSeal(PipeTransferFileSealReq.fromTPipeTransferReq(req), partitionFetcher, schemaFetcher);
                }
            }
        }
        TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TYPE_ERROR, (String)String.format("Unknown PipeRequestType %s.", rawRequestType));
        LOGGER.warn("Unknown PipeRequestType, response status = {}.", (Object)status);
        return new TPipeTransferResp(status);
    }

    private TPipeTransferResp handleTransferHandshake(PipeTransferHandshakeReq req) {
        if (!CommonDescriptor.getInstance().getConfig().getTimestampPrecision().equals(req.getTimestampPrecision())) {
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_HANDSHAKE_ERROR, (String)String.format("IoTDB receiver's timestamp precision %s, connector's timestamp precision %s. Validation fails.", CommonDescriptor.getInstance().getConfig().getTimestampPrecision(), req.getTimestampPrecision()));
            LOGGER.warn("Handshake failed, response status = {}.", (Object)status);
            return new TPipeTransferResp(status);
        }
        this.receiverId.set(RECEIVER_ID_GENERATOR.incrementAndGet());
        if (this.receiverFileDirWithIdSuffix.get() != null) {
            if (this.receiverFileDirWithIdSuffix.get().exists()) {
                try {
                    Files.delete(this.receiverFileDirWithIdSuffix.get().toPath());
                    LOGGER.info("Original receiver file dir {} was deleted.", (Object)this.receiverFileDirWithIdSuffix.get().getPath());
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to delete original receiver file dir {}, because {}.", (Object)this.receiverFileDirWithIdSuffix.get().getPath(), (Object)e.getMessage());
                }
            } else {
                LOGGER.info("Original receiver file dir {} is not existed. No need to delete.", (Object)this.receiverFileDirWithIdSuffix.get().getPath());
            }
            this.receiverFileDirWithIdSuffix.set(null);
        } else {
            LOGGER.info("Current receiver file dir is null. No need to delete.");
        }
        File newReceiverDir = new File(RECEIVER_FILE_BASE_DIR, Long.toString(this.receiverId.get()));
        if (!newReceiverDir.exists()) {
            if (newReceiverDir.mkdirs()) {
                LOGGER.info("Receiver file dir {} was created.", (Object)newReceiverDir.getPath());
            } else {
                LOGGER.error("Failed to create receiver file dir {}.", (Object)newReceiverDir.getPath());
            }
        }
        this.receiverFileDirWithIdSuffix.set(newReceiverDir);
        LOGGER.info("Handshake successfully, receiver id = {}, receiver file dir = {}.", (Object)this.receiverId.get(), (Object)newReceiverDir.getPath());
        return new TPipeTransferResp(RpcUtils.SUCCESS_STATUS);
    }

    private TPipeTransferResp handleTransferInsertNode(PipeTransferInsertNodeReq req, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        return new TPipeTransferResp(this.executeStatement(req.constructStatement(), partitionFetcher, schemaFetcher));
    }

    private TPipeTransferResp handleTransferTablet(PipeTransferTabletReq req, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        InsertTabletStatement statement = req.constructStatement();
        return new TPipeTransferResp(statement.isEmpty() ? RpcUtils.SUCCESS_STATUS : this.executeStatement(statement, partitionFetcher, schemaFetcher));
    }

    private TPipeTransferResp handleTransferFilePiece(PipeTransferFilePieceReq req) {
        try {
            this.updateWritingFileIfNeeded(req.getFileName());
            if (!this.isWritingFileOffsetCorrect(req.getStartWritingOffset())) {
                TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_OFFSET_RESET, (String)String.format("Request sender to reset file reader's offset from %s to %s.", req.getStartWritingOffset(), this.writingFileWriter.length()));
                LOGGER.warn("File offset reset requested by receiver, response status = {}.", (Object)status);
                return PipeTransferFilePieceResp.toTPipeTransferResp(status, this.writingFileWriter.length());
            }
            this.writingFileWriter.write(req.getFilePiece());
            return PipeTransferFilePieceResp.toTPipeTransferResp(RpcUtils.SUCCESS_STATUS, this.writingFileWriter.length());
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Failed to write file piece from req %s.", new Object[]{req}), (Throwable)e);
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_ERROR, (String)String.format("Failed to write file piece, because %s", e.getMessage()));
            try {
                return PipeTransferFilePieceResp.toTPipeTransferResp(status, -1L);
            }
            catch (IOException ex) {
                return PipeTransferFilePieceResp.toTPipeTransferResp(status);
            }
        }
    }

    private void updateWritingFileIfNeeded(String fileName) throws IOException {
        if (this.isFileExistedAndNameCorrect(fileName)) {
            return;
        }
        LOGGER.info("Writing file {} is not existed or name is not correct, try to create it. Current writing file is {}.", (Object)fileName, (Object)(this.writingFile == null ? "null" : this.writingFile.getPath()));
        this.closeCurrentWritingFileWriter();
        this.deleteCurrentWritingFile();
        if (!this.receiverFileDirWithIdSuffix.get().exists()) {
            if (this.receiverFileDirWithIdSuffix.get().mkdirs()) {
                LOGGER.info("Receiver file dir {} was created.", (Object)this.receiverFileDirWithIdSuffix.get().getPath());
            } else {
                LOGGER.error("Failed to create receiver file dir {}.", (Object)this.receiverFileDirWithIdSuffix.get().getPath());
            }
        }
        this.writingFile = new File(this.receiverFileDirWithIdSuffix.get(), fileName);
        this.writingFileWriter = new RandomAccessFile(this.writingFile, "rw");
        LOGGER.info("Writing file {} was created. Ready to write file pieces.", (Object)this.writingFile.getPath());
    }

    private boolean isFileExistedAndNameCorrect(String fileName) {
        return this.writingFile != null && this.writingFile.getName().equals(fileName);
    }

    private void closeCurrentWritingFileWriter() {
        if (this.writingFileWriter != null) {
            try {
                this.writingFileWriter.close();
                LOGGER.info("Current writing file writer {} was closed.", (Object)(this.writingFile == null ? "null" : this.writingFile.getPath()));
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close current writing file writer {}, because {}.", (Object)(this.writingFile == null ? "null" : this.writingFile.getPath()), (Object)e.getMessage());
            }
            this.writingFileWriter = null;
        } else {
            LOGGER.info("Current writing file writer is null. No need to close.");
        }
    }

    private void deleteCurrentWritingFile() {
        if (this.writingFile != null) {
            if (this.writingFile.exists()) {
                try {
                    Files.delete(this.writingFile.toPath());
                    LOGGER.info("Original writing file {} was deleted.", (Object)this.writingFile.getPath());
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to delete original writing file {}, because {}.", (Object)this.writingFile.getPath(), (Object)e.getMessage());
                }
            } else {
                LOGGER.info("Original file {} is not existed. No need to delete.", (Object)this.writingFile.getPath());
            }
            this.writingFile = null;
        } else {
            LOGGER.info("Current writing file is null. No need to delete.");
        }
    }

    private boolean isWritingFileOffsetCorrect(long offset) throws IOException {
        boolean offsetCorrect;
        boolean bl = offsetCorrect = this.writingFileWriter.length() == offset;
        if (!offsetCorrect) {
            LOGGER.warn("Writing file {}'s offset is {}, but request sender's offset is {}.", new Object[]{this.writingFile.getPath(), this.writingFileWriter.length(), offset});
        }
        return offsetCorrect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TPipeTransferResp handleTransferFileSeal(PipeTransferFileSealReq req, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        try {
            if (!this.isWritingFileAvailable()) {
                TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file, because writing file %s is not available.", req.getFileName()));
                LOGGER.warn(status.getMessage());
                TPipeTransferResp tPipeTransferResp = new TPipeTransferResp(status);
                return tPipeTransferResp;
            }
            if (!this.isFileExistedAndNameCorrect(req.getFileName())) {
                TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s, but writing file is %s.", req.getFileName(), this.writingFile));
                LOGGER.warn(status.getMessage());
                TPipeTransferResp tPipeTransferResp = new TPipeTransferResp(status);
                return tPipeTransferResp;
            }
            if (!this.isWritingFileOffsetCorrect(req.getFileLength())) {
                TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s, because the length of file is not correct. The original file has length %s, but receiver file has length %s.", req.getFileName(), req.getFileLength(), this.writingFileWriter.length()));
                LOGGER.warn(status.getMessage());
                TPipeTransferResp tPipeTransferResp = new TPipeTransferResp(status);
                return tPipeTransferResp;
            }
            String fileAbsolutePath = this.writingFile.getAbsolutePath();
            LoadTsFileStatement statement = new LoadTsFileStatement(fileAbsolutePath);
            this.writingFileWriter.close();
            this.writingFileWriter = null;
            this.writingFile = null;
            statement.setDeleteAfterLoad(true);
            statement.setVerifySchema(true);
            statement.setAutoCreateDatabase(false);
            TSStatus status = this.executeStatement(statement, partitionFetcher, schemaFetcher);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.info("Seal file {} successfully. Receiver id is {}.", (Object)fileAbsolutePath, (Object)this.receiverId.get());
            } else {
                LOGGER.warn("Failed to seal file {}, because {}. Receiver id is {}.", new Object[]{fileAbsolutePath, status.getMessage(), this.receiverId.get()});
            }
            TPipeTransferResp tPipeTransferResp = new TPipeTransferResp(status);
            return tPipeTransferResp;
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Failed to seal file %s from req %s. Receiver id is %d.", new Object[]{this.writingFile, req, this.receiverId.get()}), (Throwable)e);
            TPipeTransferResp tPipeTransferResp = new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s because %s", this.writingFile, e.getMessage())));
            return tPipeTransferResp;
        }
        finally {
            this.closeCurrentWritingFileWriter();
            this.deleteCurrentWritingFile();
        }
    }

    private boolean isWritingFileAvailable() {
        boolean isWritingFileAvailable;
        boolean bl = isWritingFileAvailable = this.writingFile != null && this.writingFile.exists() && this.writingFileWriter != null;
        if (!isWritingFileAvailable) {
            LOGGER.info("Writing file {} is not available. Writing file is null: {}, writing file exists: {}, writing file writer is null: {}.", new Object[]{this.writingFile, this.writingFile == null, this.writingFile != null && this.writingFile.exists(), this.writingFileWriter == null});
        }
        return isWritingFileAvailable;
    }

    private TSStatus executeStatement(Statement statement, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        if (statement == null) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TRANSFER_EXECUTE_STATEMENT_ERROR, (String)"Execute null statement.");
        }
        long queryId = SessionManager.getInstance().requestQueryId();
        ExecutionResult result = Coordinator.getInstance().execute(statement, queryId, null, "", partitionFetcher, schemaFetcher, IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold());
        if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("failed to execute statement, statement: {}, result status is: {}", (Object)statement, (Object)result.status);
        }
        return result.status;
    }

    @Override
    public synchronized void handleExit() {
        if (this.writingFileWriter != null) {
            try {
                this.writingFileWriter.close();
                LOGGER.info("IoTDBThriftReceiverV1#handleExit: writing file writer was closed.");
            }
            catch (Exception e) {
                LOGGER.warn("IoTDBThriftReceiverV1#handleExit: close writing file writer error.", (Throwable)e);
            }
            this.writingFileWriter = null;
        } else {
            LOGGER.info("IoTDBThriftReceiverV1#handleExit: writing file writer is null. No need to close.");
        }
        if (this.writingFile != null) {
            try {
                Files.delete(this.writingFile.toPath());
                LOGGER.info("IoTDBThriftReceiverV1#handleExit: writing file {} was deleted.", (Object)this.writingFile.getPath());
            }
            catch (Exception e) {
                LOGGER.warn("IoTDBThriftReceiverV1#handleExit: delete file {} error.", (Object)this.writingFile.getPath());
            }
            this.writingFile = null;
        } else {
            LOGGER.info("IoTDBThriftReceiverV1#handleExit: writing file is null. No need to delete.");
        }
        if (this.receiverFileDirWithIdSuffix.get() != null) {
            if (this.receiverFileDirWithIdSuffix.get().exists()) {
                try {
                    Files.delete(this.receiverFileDirWithIdSuffix.get().toPath());
                    LOGGER.info("IoTDBThriftReceiverV1#handleExit: original receiver file dir {} was deleted.", (Object)this.receiverFileDirWithIdSuffix.get().getPath());
                }
                catch (IOException e) {
                    LOGGER.warn("IoTDBThriftReceiverV1#handleExit: delete original receiver file dir {} error.", (Object)this.receiverFileDirWithIdSuffix.get().getPath());
                }
            } else {
                LOGGER.info("IoTDBThriftReceiverV1#handleExit: original receiver file dir {} does not exist. No need to delete.", (Object)this.receiverFileDirWithIdSuffix.get().getPath());
            }
            this.receiverFileDirWithIdSuffix.set(null);
        } else {
            LOGGER.info("IoTDBThriftReceiverV1#handleExit: original receiver file dir is null. No need to delete.");
        }
        LOGGER.info("IoTDBThriftReceiverV1#handleExit: receiver exited.");
    }

    @Override
    public IoTDBThriftConnectorRequestVersion getVersion() {
        return IoTDBThriftConnectorRequestVersion.VERSION_1;
    }
}

