/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor;

import java.io.IOException;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class PipeDoNothingProcessor
implements PipeProcessor {
    public void validate(PipeParameterValidator validator) {
    }

    public void customize(PipeParameters parameters, PipeProcessorRuntimeConfiguration configuration) {
    }

    public void process(TabletInsertionEvent tabletInsertionEvent, EventCollector eventCollector) throws IOException {
        if (tabletInsertionEvent instanceof EnrichedEvent) {
            EnrichedEvent enrichedEvent = (EnrichedEvent)tabletInsertionEvent;
            if (enrichedEvent.getPattern().equals("root")) {
                eventCollector.collect((Event)tabletInsertionEvent);
            } else {
                tabletInsertionEvent.processRowByRow((row, rowCollector) -> {
                    try {
                        rowCollector.collectRow(row);
                    }
                    catch (IOException e) {
                        throw new PipeException("Failed to collect row", (Throwable)e);
                    }
                }).forEach(event -> {
                    try {
                        eventCollector.collect((Event)event);
                    }
                    catch (IOException e) {
                        throw new PipeException("Failed to collect event", (Throwable)e);
                    }
                });
            }
        } else {
            eventCollector.collect((Event)tabletInsertionEvent);
        }
    }

    public void process(TsFileInsertionEvent tsFileInsertionEvent, EventCollector eventCollector) throws IOException {
        if (tsFileInsertionEvent instanceof PipeTsFileInsertionEvent) {
            PipeTsFileInsertionEvent enrichedEvent = (PipeTsFileInsertionEvent)tsFileInsertionEvent;
            if (enrichedEvent.getPattern().equals("root") && !enrichedEvent.hasTimeFilter()) {
                eventCollector.collect((Event)tsFileInsertionEvent);
            } else {
                for (TabletInsertionEvent tabletInsertionEvent : tsFileInsertionEvent.toTabletInsertionEvents()) {
                    eventCollector.collect((Event)tabletInsertionEvent);
                }
            }
        } else {
            eventCollector.collect((Event)tsFileInsertionEvent);
        }
    }

    public void process(Event event, EventCollector eventCollector) throws IOException {
        eventCollector.collect(event);
    }

    public void close() {
    }
}

