/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.realtime.epoch;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.epoch.TsFileEpoch;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileEpochManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileEpochManager.class);
    private static final String[] EMPTY_MEASUREMENT_ARRAY = new String[0];
    private final Map<String, TsFileEpoch> filePath2Epoch = new HashMap<String, TsFileEpoch>();

    public PipeRealtimeEvent bindPipeTsFileInsertionEvent(PipeTsFileInsertionEvent event, TsFileResource resource) {
        String filePath = resource.getTsFilePath();
        this.filePath2Epoch.computeIfAbsent(filePath, path -> {
            LOGGER.info("TsFileEpoch not found for TsFile {}, creating a new one", path);
            return new TsFileEpoch((String)path);
        });
        return new PipeRealtimeEvent(event, this.filePath2Epoch.remove(filePath), resource.getDevices().stream().collect(Collectors.toMap(device -> device, device -> EMPTY_MEASUREMENT_ARRAY)), event.getPattern());
    }

    public PipeRealtimeEvent bindPipeInsertNodeTabletInsertionEvent(PipeInsertNodeTabletInsertionEvent event, InsertNode node, TsFileResource resource) {
        return new PipeRealtimeEvent(event, this.filePath2Epoch.computeIfAbsent(resource.getTsFilePath(), TsFileEpoch::new), Collections.singletonMap(node.getDevicePath().getFullPath(), node.getMeasurements()), event.getPattern());
    }
}

