/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.pipe.api.event.Event;

public abstract class EnrichedEvent
implements Event {
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private final PipeTaskMeta pipeTaskMeta;
    private final String pattern;

    protected EnrichedEvent(PipeTaskMeta pipeTaskMeta, String pattern) {
        this.pipeTaskMeta = pipeTaskMeta;
        this.pattern = pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean increaseReferenceCount(String holderMessage) {
        boolean isSuccessful = true;
        EnrichedEvent enrichedEvent = this;
        synchronized (enrichedEvent) {
            if (this.referenceCount.get() == 0) {
                isSuccessful = this.internallyIncreaseResourceReferenceCount(holderMessage);
            }
            this.referenceCount.incrementAndGet();
        }
        return isSuccessful;
    }

    public abstract boolean internallyIncreaseResourceReferenceCount(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decreaseReferenceCount(String holderMessage) {
        boolean isSuccessful = true;
        EnrichedEvent enrichedEvent = this;
        synchronized (enrichedEvent) {
            if (this.referenceCount.get() == 1) {
                isSuccessful = this.internallyDecreaseResourceReferenceCount(holderMessage);
                this.reportProgress();
            }
            this.referenceCount.decrementAndGet();
        }
        return isSuccessful;
    }

    public abstract boolean internallyDecreaseResourceReferenceCount(String var1);

    private void reportProgress() {
        if (this.pipeTaskMeta != null) {
            this.pipeTaskMeta.updateProgressIndex(this.getProgressIndex());
        }
    }

    public abstract ProgressIndex getProgressIndex();

    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    public final String getPattern() {
        return this.pattern == null ? "root" : this.pattern;
    }

    public abstract EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(PipeTaskMeta var1, String var2);

    public void reportException(PipeRuntimeException pipeRuntimeException) {
        PipeAgent.runtime().report(this.pipeTaskMeta, pipeRuntimeException);
    }
}

