/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.sync.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.UpdateRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeToStatusResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.partition.PartitionMetrics;
import org.apache.iotdb.confignode.persistence.node.NodeInfo;
import org.apache.iotdb.confignode.procedure.scheduler.LockQueue;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.mpp.rpc.thrift.TCreatePeerReq;
import org.apache.iotdb.mpp.rpc.thrift.TDisableDataNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TMaintainPeerReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeRemoveHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeRemoveHandler.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private final ConfigManager configManager;
    private final LockQueue regionMigrateLock = new LockQueue();

    public DataNodeRemoveHandler(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public static String getIdWithRpcEndpoint(TDataNodeLocation location) {
        return String.format("[dataNodeId: %s, clientRpcEndPoint: %s]", location.getDataNodeId(), location.getClientRpcEndPoint());
    }

    public List<TConsensusGroupId> getMigratedDataNodeRegions(TDataNodeLocation removedDataNode) {
        return this.configManager.getPartitionManager().getAllReplicaSets().stream().filter(replicaSet -> replicaSet.getDataNodeLocations().contains(removedDataNode) && replicaSet.regionId.getType() != TConsensusGroupType.ConfigRegion).map(TRegionReplicaSet::getRegionId).collect(Collectors.toList());
    }

    public void broadcastDisableDataNode(TDataNodeLocation disabledDataNode) {
        LOGGER.info("DataNodeRemoveService start broadcastDisableDataNode to cluster, disabledDataNode: {}", (Object)DataNodeRemoveHandler.getIdWithRpcEndpoint(disabledDataNode));
        List otherOnlineDataNodes = this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running).stream().filter(node -> !node.getLocation().equals(disabledDataNode)).collect(Collectors.toList());
        for (TDataNodeConfiguration node2 : otherOnlineDataNodes) {
            TDisableDataNodeReq disableReq = new TDisableDataNodeReq(disabledDataNode);
            TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(node2.getLocation().getInternalEndPoint(), disableReq, DataNodeRequestType.DISABLE_DATA_NODE);
            if (this.isSucceed(status)) continue;
            LOGGER.error("{}, BroadcastDisableDataNode meets error, disabledDataNode: {}, error: {}", new Object[]{"[REMOVE_DATANODE_PROCESS]", DataNodeRemoveHandler.getIdWithRpcEndpoint(disabledDataNode), status});
            return;
        }
        LOGGER.info("{}, DataNodeRemoveService finished broadcastDisableDataNode to cluster, disabledDataNode: {}", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)DataNodeRemoveHandler.getIdWithRpcEndpoint(disabledDataNode));
    }

    public TDataNodeLocation findDestDataNode(TConsensusGroupId regionId) {
        List<TDataNodeLocation> regionReplicaNodes = this.findRegionLocations(regionId);
        if (regionReplicaNodes.isEmpty()) {
            LOGGER.warn("Cannot find region replica nodes, region: {}", (Object)regionId);
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("Cannot find region replica nodes, region: " + regionId);
            return null;
        }
        Optional<TDataNodeLocation> newNode = this.pickNewReplicaNodeForRegion(regionReplicaNodes);
        if (!newNode.isPresent()) {
            LOGGER.warn("No enough Data node to migrate region: {}", (Object)regionId);
            return null;
        }
        return newNode.get();
    }

    public TSStatus createNewRegionPeer(TConsensusGroupId regionId, TDataNodeLocation destDataNode) {
        List currentPeerNodes;
        List<TDataNodeLocation> regionReplicaNodes = this.findRegionLocations(regionId);
        if (regionReplicaNodes.isEmpty()) {
            LOGGER.warn("{}, Cannot find region replica nodes in createPeer, regionId: {}", (Object)"[REGION_MIGRATE_PROCESS]", (Object)regionId);
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("Not find region replica nodes in createPeer, regionId: " + regionId);
            return status;
        }
        if (TConsensusGroupType.DataRegion.equals((Object)regionId.getType()) && "org.apache.iotdb.consensus.iot.IoTConsensus".equals(CONF.getDataRegionConsensusProtocolClass())) {
            currentPeerNodes = new ArrayList<TDataNodeLocation>(regionReplicaNodes);
            currentPeerNodes.add(destDataNode);
        } else {
            currentPeerNodes = Collections.emptyList();
        }
        String storageGroup = this.configManager.getPartitionManager().getRegionStorageGroup(regionId);
        TCreatePeerReq req = new TCreatePeerReq(regionId, currentPeerNodes, storageGroup);
        req.setTtl(Long.MAX_VALUE);
        TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(destDataNode.getInternalEndPoint(), req, DataNodeRequestType.CREATE_NEW_REGION_PEER);
        LOGGER.info("{}, Send action createNewRegionPeer finished, regionId: {}, newPeerDataNodeId: {}", new Object[]{"[REGION_MIGRATE_PROCESS]", regionId, DataNodeRemoveHandler.getIdWithRpcEndpoint(destDataNode)});
        if (this.isFailed(status)) {
            LOGGER.error("{}, Send action createNewRegionPeer error, regionId: {}, newPeerDataNodeId: {}, result: {}", new Object[]{"[REGION_MIGRATE_PROCESS]", regionId, DataNodeRemoveHandler.getIdWithRpcEndpoint(destDataNode), status});
        }
        return status;
    }

    public TSStatus addRegionPeer(TDataNodeLocation destDataNode, TConsensusGroupId regionId) {
        Optional<TDataNodeLocation> selectedDataNode = this.filterDataNodeWithOtherRegionReplica(regionId, destDataNode);
        if (!selectedDataNode.isPresent()) {
            LOGGER.warn("{}, There are no other DataNodes could be selected to perform the add peer process, please check RegionGroup: {} by show regions sql command", (Object)"[REGION_MIGRATE_PROCESS]", (Object)regionId);
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("There are no other DataNodes could be selected to perform the add peer process, please check by show regions sql command");
            return status;
        }
        TMaintainPeerReq maintainPeerReq = new TMaintainPeerReq(regionId, destDataNode);
        TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(selectedDataNode.get().getInternalEndPoint(), maintainPeerReq, DataNodeRequestType.ADD_REGION_PEER);
        LOGGER.info("{}, Send action addRegionPeer finished, regionId: {}, rpcDataNode: {},  destDataNode: {}", new Object[]{"[REGION_MIGRATE_PROCESS]", regionId, DataNodeRemoveHandler.getIdWithRpcEndpoint(selectedDataNode.get()), DataNodeRemoveHandler.getIdWithRpcEndpoint(destDataNode)});
        return status;
    }

    public TSStatus removeRegionPeer(TDataNodeLocation originalDataNode, TDataNodeLocation destDataNode, TConsensusGroupId regionId) {
        Optional<TDataNodeLocation> selectedDataNode = this.filterDataNodeWithOtherRegionReplica(regionId, originalDataNode);
        TDataNodeLocation rpcClientDataNode = selectedDataNode.orElse(destDataNode);
        TMaintainPeerReq maintainPeerReq = new TMaintainPeerReq(regionId, originalDataNode);
        TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(rpcClientDataNode.getInternalEndPoint(), maintainPeerReq, DataNodeRequestType.REMOVE_REGION_PEER);
        LOGGER.info("{}, Send action removeRegionPeer finished, regionId: {}, rpcDataNode: {}", new Object[]{"[REGION_MIGRATE_PROCESS]", regionId, DataNodeRemoveHandler.getIdWithRpcEndpoint(rpcClientDataNode)});
        return status;
    }

    public TSStatus deleteOldRegionPeer(TDataNodeLocation originalDataNode, TConsensusGroupId regionId) {
        TMaintainPeerReq maintainPeerReq = new TMaintainPeerReq(regionId, originalDataNode);
        TSStatus status = this.configManager.getLoadManager().getNodeStatus(originalDataNode.getDataNodeId()) == NodeStatus.Unknown ? SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithGivenRetry(originalDataNode.getInternalEndPoint(), maintainPeerReq, DataNodeRequestType.DELETE_OLD_REGION_PEER, 1) : SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(originalDataNode.getInternalEndPoint(), maintainPeerReq, DataNodeRequestType.DELETE_OLD_REGION_PEER);
        LOGGER.info("{}, Send action deleteOldRegionPeer finished, regionId: {}, dataNodeId: {}", new Object[]{"[REGION_MIGRATE_PROCESS]", regionId, originalDataNode.getInternalEndPoint()});
        return status;
    }

    public void updateRegionLocationCache(TConsensusGroupId regionId, TDataNodeLocation originalDataNode, TDataNodeLocation destDataNode) {
        LOGGER.info("Start to updateRegionLocationCache {} location from {} to {} when it migrate succeed", new Object[]{regionId, DataNodeRemoveHandler.getIdWithRpcEndpoint(originalDataNode), DataNodeRemoveHandler.getIdWithRpcEndpoint(destDataNode)});
        UpdateRegionLocationPlan req = new UpdateRegionLocationPlan(regionId, originalDataNode, destDataNode);
        TSStatus status = this.configManager.getPartitionManager().updateRegionLocation(req);
        LOGGER.info("UpdateRegionLocationCache finished, region:{}, result:{}, old:{}, new:{}", new Object[]{regionId, status, DataNodeRemoveHandler.getIdWithRpcEndpoint(originalDataNode), DataNodeRemoveHandler.getIdWithRpcEndpoint(destDataNode)});
        this.configManager.getLoadManager().removeRegionGroupCache(regionId);
        this.configManager.getLoadManager().broadcastLatestRegionRouteMap();
    }

    public List<TDataNodeLocation> findRegionLocations(TConsensusGroupId regionId) {
        Optional<TRegionReplicaSet> regionReplicaSet = this.configManager.getPartitionManager().getAllReplicaSets().stream().filter(rg -> rg.regionId.equals(regionId)).findAny();
        if (regionReplicaSet.isPresent()) {
            return regionReplicaSet.get().getDataNodeLocations();
        }
        return Collections.emptyList();
    }

    private Optional<TDataNodeLocation> pickNewReplicaNodeForRegion(List<TDataNodeLocation> regionReplicaNodes) {
        List<TDataNodeConfiguration> dataNodeConfigurations = this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running);
        Collections.shuffle(dataNodeConfigurations);
        return dataNodeConfigurations.stream().map(TDataNodeConfiguration::getLocation).filter(e -> !regionReplicaNodes.contains(e)).findAny();
    }

    private boolean isSucceed(TSStatus status) {
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
    }

    private boolean isFailed(TSStatus status) {
        return !this.isSucceed(status);
    }

    public void stopDataNode(TDataNodeLocation dataNode) {
        LOGGER.info("{}, Begin to stop DataNode and kill the DataNode process {}", (Object)"[REMOVE_DATANODE_PROCESS]", (Object)dataNode);
        TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithGivenRetry(dataNode.getInternalEndPoint(), dataNode, DataNodeRequestType.STOP_DATA_NODE, 2);
        this.configManager.getLoadManager().removeNodeCache(dataNode.getDataNodeId());
        LOGGER.info("{}, Stop Data Node result: {}, stoppedDataNode: {}", new Object[]{"[REMOVE_DATANODE_PROCESS]", status, dataNode});
    }

    public DataNodeToStatusResp checkRemoveDataNodeRequest(RemoveDataNodePlan removeDataNodePlan) {
        DataNodeToStatusResp dataSet = new DataNodeToStatusResp();
        dataSet.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        TSStatus status = this.checkClusterProtocol();
        if (this.isFailed(status)) {
            dataSet.setStatus(status);
            return dataSet;
        }
        status = this.checkRegionReplication(removeDataNodePlan);
        if (this.isFailed(status)) {
            dataSet.setStatus(status);
            return dataSet;
        }
        status = this.checkDataNodeExist(removeDataNodePlan);
        if (this.isFailed(status)) {
            dataSet.setStatus(status);
            return dataSet;
        }
        return dataSet;
    }

    private TSStatus checkDataNodeExist(RemoveDataNodePlan removeDataNodePlan) {
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        List allDataNodes = this.configManager.getNodeManager().getRegisteredDataNodes().stream().map(TDataNodeConfiguration::getLocation).collect(Collectors.toList());
        boolean hasNotExistNode = removeDataNodePlan.getDataNodeLocations().stream().anyMatch(loc -> !allDataNodes.contains(loc));
        if (hasNotExistNode) {
            status.setCode(TSStatusCode.DATANODE_NOT_EXIST.getStatusCode());
            status.setMessage("there exist Data Node in request but not in cluster");
        }
        return status;
    }

    private TSStatus checkRegionReplication(RemoveDataNodePlan removeDataNodePlan) {
        int removedDataNodeSize;
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        List<TDataNodeLocation> removedDataNodes = removeDataNodePlan.getDataNodeLocations();
        int availableDatanodeSize = this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running, NodeStatus.ReadOnly).size();
        if (CONF.getSchemaReplicationFactor() == 1 || CONF.getDataReplicationFactor() == 1) {
            for (TDataNodeLocation dataNodeLocation : removedDataNodes) {
                if (!NodeStatus.Running.equals((Object)this.configManager.getLoadManager().getNodeStatus(dataNodeLocation.getDataNodeId()))) {
                    removedDataNodes.remove(dataNodeLocation);
                    LOGGER.error("Failed to remove data node {} because it is not in running and the configuration of cluster is one replication", (Object)dataNodeLocation);
                }
                if (!removedDataNodes.isEmpty()) continue;
                status.setCode(TSStatusCode.NO_ENOUGH_DATANODE.getStatusCode());
                status.setMessage("Failed to remove all requested data nodes");
                return status;
            }
        }
        if (availableDatanodeSize - (removedDataNodeSize = (int)removeDataNodePlan.getDataNodeLocations().stream().filter(x -> this.configManager.getLoadManager().getNodeStatus(x.getDataNodeId()) != NodeStatus.Unknown).count()) < NodeInfo.getMinimumDataNode()) {
            status.setCode(TSStatusCode.NO_ENOUGH_DATANODE.getStatusCode());
            status.setMessage(String.format("Can't remove datanode due to the limit of replication factor, availableDataNodeSize: %s, maxReplicaFactor: %s, max allowed removed Data Node size is: %s", availableDatanodeSize, NodeInfo.getMinimumDataNode(), availableDatanodeSize - NodeInfo.getMinimumDataNode()));
        }
        return status;
    }

    public LockQueue getRegionMigrateLock() {
        return this.regionMigrateLock;
    }

    public void removeDataNodePersistence(TDataNodeLocation dataNodeLocation) {
        List<TDataNodeLocation> removeDataNodes = Collections.singletonList(dataNodeLocation);
        this.configManager.getConsensusManager().write(new RemoveDataNodePlan(removeDataNodes));
        this.configManager.getClusterSchemaManager().adjustMaxRegionGroupNum();
        PartitionMetrics.unbindDataNodePartitionMetrics((AbstractMetricService)MetricService.getInstance(), NodeUrlUtils.convertTEndPointUrl((TEndPoint)dataNodeLocation.getClientRpcEndPoint()));
    }

    public void changeRegionLeader(TConsensusGroupId regionId, TDataNodeLocation originalDataNode, TDataNodeLocation migrateDestDataNode) {
        Optional<TDataNodeLocation> newLeaderNode = this.filterDataNodeWithOtherRegionReplica(regionId, originalDataNode);
        if (TConsensusGroupType.DataRegion.equals((Object)regionId.getType()) && "org.apache.iotdb.consensus.iot.IoTConsensus".equals(CONF.getDataRegionConsensusProtocolClass())) {
            if (CONF.getDataReplicationFactor() == 1) {
                newLeaderNode = Optional.of(migrateDestDataNode);
            }
            if (newLeaderNode.isPresent()) {
                this.configManager.getLoadManager().forceUpdateRegionLeader(regionId, newLeaderNode.get().getDataNodeId());
                LOGGER.info("{}, Change region leader finished for IOT_CONSENSUS, regionId: {}, newLeaderNode: {}", new Object[]{"[REGION_MIGRATE_PROCESS]", regionId, newLeaderNode});
            }
            return;
        }
        if (newLeaderNode.isPresent()) {
            SyncDataNodeClientPool.getInstance().changeRegionLeader(regionId, originalDataNode.getInternalEndPoint(), newLeaderNode.get());
            LOGGER.info("{}, Change region leader finished for RATIS_CONSENSUS, regionId: {}, newLeaderNode: {}", new Object[]{"[REGION_MIGRATE_PROCESS]", regionId, newLeaderNode});
        }
    }

    private Optional<TDataNodeLocation> filterDataNodeWithOtherRegionReplica(TConsensusGroupId regionId, TDataNodeLocation filterLocation) {
        List<TDataNodeLocation> regionLocations = this.findRegionLocations(regionId);
        if (regionLocations.isEmpty()) {
            LOGGER.warn("Cannot find DataNodes contain the given region: {}", (Object)regionId);
            return Optional.empty();
        }
        List aliveDataNodes = this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running).stream().map(TDataNodeConfiguration::getLocation).collect(Collectors.toList());
        aliveDataNodes.addAll(this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Removing).stream().map(TDataNodeConfiguration::getLocation).collect(Collectors.toList()));
        for (TDataNodeLocation aliveDataNode : aliveDataNodes) {
            if (!regionLocations.contains(aliveDataNode) || aliveDataNode.equals(filterLocation)) continue;
            return Optional.of(aliveDataNode);
        }
        return Optional.empty();
    }

    private TSStatus checkClusterProtocol() {
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        if (CONF.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.simple.SimpleConsensus") || CONF.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.simple.SimpleConsensus")) {
            status.setCode(TSStatusCode.REMOVE_DATANODE_ERROR.getStatusCode());
            status.setMessage("SimpleConsensus protocol is not supported to remove data node");
        }
        return status;
    }
}

