/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.executor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.MNodeType;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.read.database.CountDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.database.GetDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.datanode.GetDataNodeConfigurationPlan;
import org.apache.iotdb.confignode.consensus.request.read.function.GetUDFJarPlan;
import org.apache.iotdb.confignode.consensus.request.read.model.ShowModelPlan;
import org.apache.iotdb.confignode.consensus.request.read.model.ShowTrailPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.CountTimeSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetNodePathsPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetSeriesSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetTimeSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.pipe.plugin.GetPipePluginJarPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionIdPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.read.template.CheckTemplateSettablePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetPathsSetTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetTemplateSetInfoPlan;
import org.apache.iotdb.confignode.consensus.request.read.trigger.GetTriggerJarPlan;
import org.apache.iotdb.confignode.consensus.request.read.trigger.GetTriggerLocationPlan;
import org.apache.iotdb.confignode.consensus.request.read.trigger.GetTriggerTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.ApplyConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.UpdateVersionInfoPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.ActiveCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.AddCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.DropCQPlan;
import org.apache.iotdb.confignode.consensus.request.write.cq.UpdateCQLastExecTimePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.AdjustMaxRegionGroupNumPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.PreDeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RegisterDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.UpdateDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.function.CreateFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.function.DropFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.model.CreateModelPlan;
import org.apache.iotdb.confignode.consensus.request.write.model.DropModelPlan;
import org.apache.iotdb.confignode.consensus.request.write.model.UpdateModelInfoPlan;
import org.apache.iotdb.confignode.consensus.request.write.model.UpdateModelStatePlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.UpdateRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.plugin.CreatePipePluginPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.plugin.DropPipePluginPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleLeaderChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleMetaChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.CreatePipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.DropPipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.SetPipeStatusPlanV2;
import org.apache.iotdb.confignode.consensus.request.write.procedure.DeleteProcedurePlan;
import org.apache.iotdb.confignode.consensus.request.write.procedure.UpdateProcedurePlan;
import org.apache.iotdb.confignode.consensus.request.write.quota.SetSpaceQuotaPlan;
import org.apache.iotdb.confignode.consensus.request.write.quota.SetThrottleQuotaPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.OfferRegionMaintainTasksPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.PollSpecificRegionMaintainTaskPlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.DropSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.ExtendSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.PreSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.PreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.RollbackPreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.SetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.UnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.AddTriggerInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.DeleteTriggerInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggerLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggerStateInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggersOnTransferNodesPlan;
import org.apache.iotdb.confignode.consensus.response.partition.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.exception.physical.UnknownPhysicalPlanTypeException;
import org.apache.iotdb.confignode.persistence.AuthorInfo;
import org.apache.iotdb.confignode.persistence.ModelInfo;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.persistence.TriggerInfo;
import org.apache.iotdb.confignode.persistence.UDFInfo;
import org.apache.iotdb.confignode.persistence.cq.CQInfo;
import org.apache.iotdb.confignode.persistence.node.NodeInfo;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.confignode.persistence.pipe.PipeInfo;
import org.apache.iotdb.confignode.persistence.quota.QuotaInfo;
import org.apache.iotdb.confignode.persistence.schema.ClusterSchemaInfo;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPlanExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigPlanExecutor.class);
    private final List<SnapshotProcessor> snapshotProcessorList = new ArrayList<SnapshotProcessor>();
    private final NodeInfo nodeInfo;
    private final ClusterSchemaInfo clusterSchemaInfo;
    private final PartitionInfo partitionInfo;
    private final AuthorInfo authorInfo;
    private final ProcedureInfo procedureInfo;
    private final UDFInfo udfInfo;
    private final TriggerInfo triggerInfo;
    private final CQInfo cqInfo;
    private final ModelInfo modelInfo;
    private final PipeInfo pipeInfo;
    private final QuotaInfo quotaInfo;

    public ConfigPlanExecutor(NodeInfo nodeInfo, ClusterSchemaInfo clusterSchemaInfo, PartitionInfo partitionInfo, AuthorInfo authorInfo, ProcedureInfo procedureInfo, UDFInfo udfInfo, TriggerInfo triggerInfo, CQInfo cqInfo, ModelInfo modelInfo, PipeInfo pipeInfo, QuotaInfo quotaInfo) {
        this.nodeInfo = nodeInfo;
        this.snapshotProcessorList.add(nodeInfo);
        this.clusterSchemaInfo = clusterSchemaInfo;
        this.snapshotProcessorList.add(clusterSchemaInfo);
        this.partitionInfo = partitionInfo;
        this.snapshotProcessorList.add(partitionInfo);
        this.authorInfo = authorInfo;
        this.snapshotProcessorList.add(authorInfo);
        this.triggerInfo = triggerInfo;
        this.snapshotProcessorList.add(triggerInfo);
        this.udfInfo = udfInfo;
        this.snapshotProcessorList.add(udfInfo);
        this.cqInfo = cqInfo;
        this.snapshotProcessorList.add(cqInfo);
        this.modelInfo = modelInfo;
        this.snapshotProcessorList.add(modelInfo);
        this.pipeInfo = pipeInfo;
        this.snapshotProcessorList.add(pipeInfo);
        this.procedureInfo = procedureInfo;
        this.quotaInfo = quotaInfo;
        this.snapshotProcessorList.add(quotaInfo);
    }

    public DataSet executeQueryPlan(ConfigPhysicalPlan req) throws UnknownPhysicalPlanTypeException, AuthException {
        switch (req.getType()) {
            case GetDataNodeConfiguration: {
                return this.nodeInfo.getDataNodeConfiguration((GetDataNodeConfigurationPlan)req);
            }
            case CountDatabase: {
                return this.clusterSchemaInfo.countMatchedDatabases((CountDatabasePlan)req);
            }
            case GetDatabase: {
                return this.clusterSchemaInfo.getMatchedDatabaseSchemas((GetDatabasePlan)req);
            }
            case GetDataPartition: 
            case GetOrCreateDataPartition: {
                return this.partitionInfo.getDataPartition((GetDataPartitionPlan)req);
            }
            case GetSchemaPartition: 
            case GetOrCreateSchemaPartition: {
                return this.partitionInfo.getSchemaPartition((GetSchemaPartitionPlan)req);
            }
            case ListUser: {
                return this.authorInfo.executeListUsers((AuthorPlan)req);
            }
            case ListRole: {
                return this.authorInfo.executeListRoles((AuthorPlan)req);
            }
            case ListUserPrivilege: {
                return this.authorInfo.executeListUserPrivileges((AuthorPlan)req);
            }
            case ListRolePrivilege: {
                return this.authorInfo.executeListRolePrivileges((AuthorPlan)req);
            }
            case GetNodePathsPartition: {
                return this.getSchemaNodeManagementPartition(req);
            }
            case GetRegionInfoList: {
                return this.getRegionInfoList(req);
            }
            case GetAllSchemaTemplate: {
                return this.clusterSchemaInfo.getAllTemplates();
            }
            case GetSchemaTemplate: {
                return this.clusterSchemaInfo.getTemplate((GetSchemaTemplatePlan)req);
            }
            case CheckTemplateSettable: {
                return this.clusterSchemaInfo.checkTemplateSettable((CheckTemplateSettablePlan)req);
            }
            case GetPathsSetTemplate: {
                return this.clusterSchemaInfo.getPathsSetTemplate((GetPathsSetTemplatePlan)req);
            }
            case GetAllTemplateSetInfo: {
                return this.clusterSchemaInfo.getAllTemplateSetInfo();
            }
            case GetTemplateSetInfo: {
                return this.clusterSchemaInfo.getTemplateSetInfo((GetTemplateSetInfoPlan)req);
            }
            case GetTriggerTable: {
                return this.triggerInfo.getTriggerTable((GetTriggerTablePlan)req);
            }
            case GetTriggerLocation: {
                return this.triggerInfo.getTriggerLocation((GetTriggerLocationPlan)req);
            }
            case GetTriggerJar: {
                return this.triggerInfo.getTriggerJar((GetTriggerJarPlan)req);
            }
            case GetTransferringTriggers: {
                return this.triggerInfo.getTransferringTriggers();
            }
            case GetRegionId: {
                return this.partitionInfo.getRegionId((GetRegionIdPlan)req);
            }
            case GetTimeSlotList: {
                return this.partitionInfo.getTimeSlotList((GetTimeSlotListPlan)req);
            }
            case CountTimeSlotList: {
                return this.partitionInfo.countTimeSlotList((CountTimeSlotListPlan)req);
            }
            case GetSeriesSlotList: {
                return this.partitionInfo.getSeriesSlotList((GetSeriesSlotListPlan)req);
            }
            case SHOW_CQ: {
                return this.cqInfo.showCQ();
            }
            case GetFunctionTable: {
                return this.udfInfo.getUDFTable();
            }
            case GetFunctionJar: {
                return this.udfInfo.getUDFJar((GetUDFJarPlan)req);
            }
            case ShowModel: {
                return this.modelInfo.showModel((ShowModelPlan)req);
            }
            case ShowTrail: {
                return this.modelInfo.showTrail((ShowTrailPlan)req);
            }
            case GetPipePluginTable: {
                return this.pipeInfo.getPipePluginInfo().showPipePlugins();
            }
            case GetPipePluginJar: {
                return this.pipeInfo.getPipePluginInfo().getPipePluginJar((GetPipePluginJarPlan)req);
            }
            case ShowPipeV2: {
                return this.pipeInfo.getPipeTaskInfo().showPipes();
            }
        }
        throw new UnknownPhysicalPlanTypeException(req.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus executeNonQueryPlan(ConfigPhysicalPlan physicalPlan) throws UnknownPhysicalPlanTypeException, AuthException {
        switch (physicalPlan.getType()) {
            case RegisterDataNode: {
                return this.nodeInfo.registerDataNode((RegisterDataNodePlan)physicalPlan);
            }
            case RemoveDataNode: {
                return this.nodeInfo.removeDataNode((RemoveDataNodePlan)physicalPlan);
            }
            case UpdateDataNodeConfiguration: {
                return this.nodeInfo.updateDataNode((UpdateDataNodePlan)physicalPlan);
            }
            case CreateDatabase: {
                TSStatus status = this.clusterSchemaInfo.createDatabase((DatabaseSchemaPlan)physicalPlan);
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    return status;
                }
                return this.partitionInfo.createDatabase((DatabaseSchemaPlan)physicalPlan);
            }
            case AlterDatabase: {
                return this.clusterSchemaInfo.alterDatabase((DatabaseSchemaPlan)physicalPlan);
            }
            case AdjustMaxRegionGroupNum: {
                return this.clusterSchemaInfo.adjustMaxRegionGroupCount((AdjustMaxRegionGroupNumPlan)physicalPlan);
            }
            case DeleteDatabase: {
                try {
                    TSStatus tSStatus = this.clusterSchemaInfo.deleteDatabase((DeleteDatabasePlan)physicalPlan);
                    return tSStatus;
                }
                finally {
                    this.partitionInfo.deleteDatabase((DeleteDatabasePlan)physicalPlan);
                }
            }
            case PreDeleteDatabase: {
                return this.partitionInfo.preDeleteDatabase((PreDeleteDatabasePlan)physicalPlan);
            }
            case SetTTL: {
                return this.clusterSchemaInfo.setTTL((SetTTLPlan)physicalPlan);
            }
            case SetSchemaReplicationFactor: {
                return this.clusterSchemaInfo.setSchemaReplicationFactor((SetSchemaReplicationFactorPlan)physicalPlan);
            }
            case SetDataReplicationFactor: {
                return this.clusterSchemaInfo.setDataReplicationFactor((SetDataReplicationFactorPlan)physicalPlan);
            }
            case SetTimePartitionInterval: {
                return this.clusterSchemaInfo.setTimePartitionInterval((SetTimePartitionIntervalPlan)physicalPlan);
            }
            case CreateRegionGroups: {
                return this.partitionInfo.createRegionGroups((CreateRegionGroupsPlan)physicalPlan);
            }
            case OfferRegionMaintainTasks: {
                return this.partitionInfo.offerRegionMaintainTasks((OfferRegionMaintainTasksPlan)physicalPlan);
            }
            case PollRegionMaintainTask: {
                return this.partitionInfo.pollRegionMaintainTask();
            }
            case PollSpecificRegionMaintainTask: {
                return this.partitionInfo.pollSpecificRegionMaintainTask((PollSpecificRegionMaintainTaskPlan)physicalPlan);
            }
            case CreateSchemaPartition: {
                return this.partitionInfo.createSchemaPartition((CreateSchemaPartitionPlan)physicalPlan);
            }
            case CreateDataPartition: {
                return this.partitionInfo.createDataPartition((CreateDataPartitionPlan)physicalPlan);
            }
            case UpdateProcedure: {
                return this.procedureInfo.updateProcedure((UpdateProcedurePlan)physicalPlan);
            }
            case DeleteProcedure: {
                return this.procedureInfo.deleteProcedure((DeleteProcedurePlan)physicalPlan);
            }
            case CreateUser: 
            case CreateRole: 
            case DropUser: 
            case DropRole: 
            case GrantRole: 
            case GrantUser: 
            case GrantRoleToUser: 
            case RevokeUser: 
            case RevokeRole: 
            case RevokeRoleFromUser: 
            case UpdateUser: {
                return this.authorInfo.authorNonQuery((AuthorPlan)physicalPlan);
            }
            case ApplyConfigNode: {
                return this.nodeInfo.applyConfigNode((ApplyConfigNodePlan)physicalPlan);
            }
            case RemoveConfigNode: {
                return this.nodeInfo.removeConfigNode((RemoveConfigNodePlan)physicalPlan);
            }
            case UpdateVersionInfo: {
                return this.nodeInfo.updateVersionInfo((UpdateVersionInfoPlan)physicalPlan);
            }
            case CreateFunction: {
                return this.udfInfo.addUDFInTable((CreateFunctionPlan)physicalPlan);
            }
            case DropFunction: {
                return this.udfInfo.dropFunction((DropFunctionPlan)physicalPlan);
            }
            case AddTriggerInTable: {
                return this.triggerInfo.addTriggerInTable((AddTriggerInTablePlan)physicalPlan);
            }
            case DeleteTriggerInTable: {
                return this.triggerInfo.deleteTriggerInTable((DeleteTriggerInTablePlan)physicalPlan);
            }
            case UpdateTriggerStateInTable: {
                return this.triggerInfo.updateTriggerStateInTable((UpdateTriggerStateInTablePlan)physicalPlan);
            }
            case UpdateTriggersOnTransferNodes: {
                return this.triggerInfo.updateTriggersOnTransferNodes((UpdateTriggersOnTransferNodesPlan)physicalPlan);
            }
            case UpdateTriggerLocation: {
                return this.triggerInfo.updateTriggerLocation((UpdateTriggerLocationPlan)physicalPlan);
            }
            case CreateSchemaTemplate: {
                return this.clusterSchemaInfo.createSchemaTemplate((CreateSchemaTemplatePlan)physicalPlan);
            }
            case UpdateRegionLocation: {
                return this.partitionInfo.updateRegionLocation((UpdateRegionLocationPlan)physicalPlan);
            }
            case SetSchemaTemplate: {
                return this.clusterSchemaInfo.setSchemaTemplate((SetSchemaTemplatePlan)physicalPlan);
            }
            case PreSetSchemaTemplate: {
                return this.clusterSchemaInfo.preSetSchemaTemplate((PreSetSchemaTemplatePlan)physicalPlan);
            }
            case CommitSetSchemaTemplate: {
                return this.clusterSchemaInfo.commitSetSchemaTemplate((CommitSetSchemaTemplatePlan)physicalPlan);
            }
            case PreUnsetTemplate: {
                return this.clusterSchemaInfo.preUnsetSchemaTemplate((PreUnsetSchemaTemplatePlan)physicalPlan);
            }
            case RollbackUnsetTemplate: {
                return this.clusterSchemaInfo.rollbackUnsetSchemaTemplate((RollbackPreUnsetSchemaTemplatePlan)physicalPlan);
            }
            case UnsetTemplate: {
                return this.clusterSchemaInfo.unsetSchemaTemplate((UnsetSchemaTemplatePlan)physicalPlan);
            }
            case DropSchemaTemplate: {
                return this.clusterSchemaInfo.dropSchemaTemplate((DropSchemaTemplatePlan)physicalPlan);
            }
            case ExtendSchemaTemplate: {
                return this.clusterSchemaInfo.extendSchemaTemplate((ExtendSchemaTemplatePlan)physicalPlan);
            }
            case CreatePipeV2: {
                return this.pipeInfo.getPipeTaskInfo().createPipe((CreatePipePlanV2)physicalPlan);
            }
            case SetPipeStatusV2: {
                return this.pipeInfo.getPipeTaskInfo().setPipeStatus((SetPipeStatusPlanV2)physicalPlan);
            }
            case DropPipeV2: {
                return this.pipeInfo.getPipeTaskInfo().dropPipe((DropPipePlanV2)physicalPlan);
            }
            case PipeHandleLeaderChange: {
                return this.pipeInfo.getPipeTaskInfo().handleLeaderChange((PipeHandleLeaderChangePlan)physicalPlan);
            }
            case PipeHandleMetaChange: {
                return this.pipeInfo.getPipeTaskInfo().handleMetaChanges((PipeHandleMetaChangePlan)physicalPlan);
            }
            case ADD_CQ: {
                return this.cqInfo.addCQ((AddCQPlan)physicalPlan);
            }
            case DROP_CQ: {
                return this.cqInfo.dropCQ((DropCQPlan)physicalPlan);
            }
            case ACTIVE_CQ: {
                return this.cqInfo.activeCQ((ActiveCQPlan)physicalPlan);
            }
            case UPDATE_CQ_LAST_EXEC_TIME: {
                return this.cqInfo.updateCQLastExecutionTime((UpdateCQLastExecTimePlan)physicalPlan);
            }
            case CreateModel: {
                return this.modelInfo.createModel((CreateModelPlan)physicalPlan);
            }
            case UpdateModelInfo: {
                return this.modelInfo.updateModelInfo((UpdateModelInfoPlan)physicalPlan);
            }
            case UpdateModelState: {
                return this.modelInfo.updateModelState((UpdateModelStatePlan)physicalPlan);
            }
            case DropModel: {
                return this.modelInfo.dropModel((DropModelPlan)physicalPlan);
            }
            case CreatePipePlugin: {
                return this.pipeInfo.getPipePluginInfo().createPipePlugin((CreatePipePluginPlan)physicalPlan);
            }
            case DropPipePlugin: {
                return this.pipeInfo.getPipePluginInfo().dropPipePlugin((DropPipePluginPlan)physicalPlan);
            }
            case CreatePipeSinkV1: 
            case DropPipeV1: 
            case DropPipeSinkV1: 
            case GetPipeSinkV1: 
            case PreCreatePipeV1: 
            case RecordPipeMessageV1: 
            case SetPipeStatusV1: 
            case ShowPipeV1: {
                return new TSStatus(TSStatusCode.INCOMPATIBLE_VERSION.getStatusCode());
            }
            case setSpaceQuota: {
                return this.quotaInfo.setSpaceQuota((SetSpaceQuotaPlan)physicalPlan);
            }
            case setThrottleQuota: {
                return this.quotaInfo.setThrottleQuota((SetThrottleQuotaPlan)physicalPlan);
            }
        }
        throw new UnknownPhysicalPlanTypeException(physicalPlan.getType());
    }

    public boolean takeSnapshot(File snapshotDir) {
        File[] fileList;
        if (!snapshotDir.exists()) {
            LOGGER.warn("snapshot directory [{}] is not exist,start to create it.", (Object)snapshotDir.getAbsolutePath());
            if (!snapshotDir.mkdirs()) {
                LOGGER.error("snapshot directory [{}] can not be created.", (Object)snapshotDir.getAbsolutePath());
                return false;
            }
        }
        if ((fileList = snapshotDir.listFiles()) != null && fileList.length > 0) {
            LOGGER.error("snapshot directory [{}] is not empty.", (Object)snapshotDir.getAbsolutePath());
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(true);
        this.snapshotProcessorList.forEach(x -> {
            boolean takeSnapshotResult = true;
            try {
                long startTime = System.currentTimeMillis();
                LOGGER.info("[ConfigNodeSnapshot] Start to take snapshot for {} into {}", (Object)x.getClass().getName(), (Object)snapshotDir.getAbsolutePath());
                takeSnapshotResult = x.processTakeSnapshot(snapshotDir);
                LOGGER.info("[ConfigNodeSnapshot] Finish to take snapshot for {}, time consumption: {} ms", (Object)x.getClass().getName(), (Object)(System.currentTimeMillis() - startTime));
            }
            catch (IOException | TException e) {
                LOGGER.error("Take snapshot error: {}", (Object)e.getMessage());
                takeSnapshotResult = false;
            }
            finally {
                if (!takeSnapshotResult) {
                    result.set(false);
                }
            }
        });
        if (result.get()) {
            LOGGER.info("[ConfigNodeSnapshot] Task snapshot success, snapshotDir: {}", (Object)snapshotDir);
        }
        return result.get();
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        if (!latestSnapshotRootDir.exists()) {
            LOGGER.error("snapshot directory [{}] is not exist, can not load snapshot with this directory.", (Object)latestSnapshotRootDir.getAbsolutePath());
            return;
        }
        AtomicBoolean result = new AtomicBoolean(true);
        this.snapshotProcessorList.parallelStream().forEach(x -> {
            try {
                long startTime = System.currentTimeMillis();
                LOGGER.info("[ConfigNodeSnapshot] Start to load snapshot for {} from {}", (Object)x.getClass().getName(), (Object)latestSnapshotRootDir.getAbsolutePath());
                x.processLoadSnapshot(latestSnapshotRootDir);
                LOGGER.info("[ConfigNodeSnapshot] Load snapshot for {} cost {} ms", (Object)x.getClass().getName(), (Object)(System.currentTimeMillis() - startTime));
            }
            catch (IOException | TException e) {
                result.set(false);
                LOGGER.error("Load snapshot error: {}", (Object)e.getMessage());
            }
        });
        if (result.get()) {
            LOGGER.info("[ConfigNodeSnapshot] Load snapshot success, latestSnapshotRootDir: {}", (Object)latestSnapshotRootDir);
        }
    }

    private DataSet getSchemaNodeManagementPartition(ConfigPhysicalPlan req) {
        Set<PartialPath> needMatchedNode;
        Set<TSchemaNode> alreadyMatchedNode;
        Object matchedChildInNextLevel;
        ArrayList<String> matchedStorageGroups = new ArrayList<String>();
        GetNodePathsPartitionPlan getNodePathsPartitionPlan = (GetNodePathsPartitionPlan)req;
        PartialPath partialPath = getNodePathsPartitionPlan.getPartialPath();
        int level = getNodePathsPartitionPlan.getLevel();
        if (-1 == level) {
            matchedChildInNextLevel = this.clusterSchemaInfo.getChildNodePathInNextLevel(partialPath);
            alreadyMatchedNode = (Set<TSchemaNode>)matchedChildInNextLevel.left;
            if (!partialPath.hasMultiLevelMatchWildcard()) {
                needMatchedNode = new HashSet();
                for (PartialPath databasePath : (Set)matchedChildInNextLevel.right) {
                    if (databasePath.getNodeLength() == partialPath.getNodeLength() + 1) continue;
                    needMatchedNode.add(databasePath);
                }
            } else {
                needMatchedNode = (Set)matchedChildInNextLevel.right;
            }
        } else {
            matchedChildInNextLevel = this.clusterSchemaInfo.getNodesListInGivenLevel(partialPath, level);
            alreadyMatchedNode = ((List)matchedChildInNextLevel.left).stream().map(path -> new TSchemaNode(path.getFullPath(), MNodeType.UNIMPLEMENT.getNodeType())).collect(Collectors.toSet());
            needMatchedNode = (Set)matchedChildInNextLevel.right;
        }
        needMatchedNode.forEach(nodePath -> matchedStorageGroups.add(nodePath.getFullPath()));
        SchemaNodeManagementResp schemaNodeManagementResp = (SchemaNodeManagementResp)this.partitionInfo.getSchemaNodeManagementPartition(matchedStorageGroups);
        if (schemaNodeManagementResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            schemaNodeManagementResp.setMatchedNode(alreadyMatchedNode);
        }
        return schemaNodeManagementResp;
    }

    private DataSet getRegionInfoList(ConfigPhysicalPlan req) {
        List storageGroups;
        List matchedStorageGroups;
        GetRegionInfoListPlan getRegionInfoListPlan = (GetRegionInfoListPlan)req;
        TShowRegionReq showRegionReq = getRegionInfoListPlan.getShowRegionReq();
        if (showRegionReq != null && showRegionReq.isSetDatabases() && !(matchedStorageGroups = this.clusterSchemaInfo.getMatchedDatabaseSchemasByName(storageGroups = showRegionReq.getDatabases()).values().stream().map(TDatabaseSchema::getName).collect(Collectors.toList())).isEmpty()) {
            showRegionReq.setDatabases(matchedStorageGroups);
        }
        return this.partitionInfo.getRegionInfoList(getRegionInfoListPlan);
    }
}

