/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.database;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class SetTTLPlan
extends ConfigPhysicalPlan {
    private String[] databasePathPattern;
    private long TTL;

    public SetTTLPlan() {
        super(ConfigPhysicalPlanType.SetTTL);
    }

    public SetTTLPlan(List<String> databasePathPattern, long TTL) {
        this();
        this.databasePathPattern = databasePathPattern.toArray(new String[0]);
        this.TTL = TTL;
    }

    public String[] getDatabasePathPattern() {
        return this.databasePathPattern;
    }

    public long getTTL() {
        return this.TTL;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.writeInt(this.databasePathPattern.length);
        for (String node : this.databasePathPattern) {
            BasicStructureSerDeUtil.write((String)node, (DataOutputStream)stream);
        }
        stream.writeLong(this.TTL);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int length = buffer.getInt();
        this.databasePathPattern = new String[length];
        for (int i = 0; i < length; ++i) {
            this.databasePathPattern[i] = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        }
        this.TTL = buffer.getLong();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetTTLPlan setTTLPlan = (SetTTLPlan)o;
        return this.TTL == setTTLPlan.TTL && Arrays.equals(this.databasePathPattern, setTTLPlan.databasePathPattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.databasePathPattern), this.TTL);
    }
}

