/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.simple;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.response.ConsensusGenericResponse;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.exception.ConsensusGroupAlreadyExistException;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.consensus.exception.IllegalPeerEndpointException;
import org.apache.iotdb.consensus.exception.IllegalPeerNumException;
import org.apache.iotdb.consensus.simple.SimpleServerImpl;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleConsensus
implements IConsensus {
    private final Logger logger = LoggerFactory.getLogger(SimpleConsensus.class);
    private final TEndPoint thisNode;
    private final int thisNodeId;
    private final File storageDir;
    private final IStateMachine.Registry registry;
    private final Map<ConsensusGroupId, SimpleServerImpl> stateMachineMap = new ConcurrentHashMap<ConsensusGroupId, SimpleServerImpl>();
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();

    public SimpleConsensus(ConsensusConfig config, IStateMachine.Registry registry) {
        this.thisNode = config.getThisNodeEndPoint();
        this.thisNodeId = config.getThisNodeId();
        this.storageDir = new File(config.getStorageDir());
        this.registry = registry;
    }

    @Override
    public void start() throws IOException {
        this.initAndRecover();
    }

    private void initAndRecover() throws IOException {
        if (!this.storageDir.exists()) {
            if (!this.storageDir.mkdirs()) {
                this.logger.warn("Unable to create consensus dir at {}", (Object)this.storageDir);
            }
        } else {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.storageDir.toPath());){
                for (Path path : stream) {
                    String[] items = path.getFileName().toString().split("_");
                    ConsensusGroupId consensusGroupId = ConsensusGroupId.Factory.create((int)Integer.parseInt(items[0]), (int)Integer.parseInt(items[1]));
                    SimpleServerImpl consensus = new SimpleServerImpl(new Peer(consensusGroupId, this.thisNodeId, this.thisNode), (IStateMachine)this.registry.apply(consensusGroupId));
                    this.stateMachineMap.put(consensusGroupId, consensus);
                    consensus.start();
                }
            }
        }
    }

    @Override
    public void stop() throws IOException {
        this.stateMachineMap.values().parallelStream().forEach(SimpleServerImpl::stop);
    }

    @Override
    public ConsensusWriteResponse write(ConsensusGroupId groupId, IConsensusRequest request) {
        TSStatus status;
        SimpleServerImpl impl = this.stateMachineMap.get(groupId);
        if (impl == null) {
            return ConsensusWriteResponse.newBuilder().setException(new ConsensusGroupNotExistException(groupId)).build();
        }
        if (impl.isReadOnly()) {
            status = new TSStatus(TSStatusCode.SYSTEM_READ_ONLY.getStatusCode());
            status.setMessage("Fail to do non-query operations because system is read-only.");
        } else if (groupId instanceof DataRegionId) {
            long startWriteTime = System.nanoTime();
            status = impl.write(request);
            PERFORMANCE_OVERVIEW_METRICS.recordEngineCost(System.nanoTime() - startWriteTime);
        } else {
            status = impl.write(request);
        }
        return ConsensusWriteResponse.newBuilder().setStatus(status).build();
    }

    @Override
    public ConsensusReadResponse read(ConsensusGroupId groupId, IConsensusRequest request) {
        SimpleServerImpl impl = this.stateMachineMap.get(groupId);
        if (impl == null) {
            return ConsensusReadResponse.newBuilder().setException(new ConsensusGroupNotExistException(groupId)).build();
        }
        return ConsensusReadResponse.newBuilder().setDataSet(impl.read(request)).build();
    }

    @Override
    public ConsensusGenericResponse createPeer(ConsensusGroupId groupId, List<Peer> peers) {
        int consensusGroupSize = peers.size();
        if (consensusGroupSize != 1) {
            return ConsensusGenericResponse.newBuilder().setException(new IllegalPeerNumException(consensusGroupSize)).build();
        }
        if (!peers.contains(new Peer(groupId, this.thisNodeId, this.thisNode))) {
            return ConsensusGenericResponse.newBuilder().setException(new IllegalPeerEndpointException(this.thisNode, peers)).build();
        }
        AtomicBoolean exist = new AtomicBoolean(true);
        this.stateMachineMap.computeIfAbsent(groupId, k -> {
            exist.set(false);
            SimpleServerImpl impl = new SimpleServerImpl((Peer)peers.get(0), (IStateMachine)this.registry.apply(groupId));
            impl.start();
            String path = this.buildPeerDir(groupId);
            File file = new File(path);
            if (!file.mkdirs()) {
                this.logger.warn("Unable to create consensus dir for group {} at {}", (Object)groupId, (Object)path);
            }
            return impl;
        });
        if (exist.get()) {
            return ConsensusGenericResponse.newBuilder().setException(new ConsensusGroupAlreadyExistException(groupId)).build();
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(true).build();
    }

    @Override
    public ConsensusGenericResponse deletePeer(ConsensusGroupId groupId) {
        AtomicBoolean exist = new AtomicBoolean(false);
        this.stateMachineMap.computeIfPresent(groupId, (k, v) -> {
            exist.set(true);
            v.stop();
            FileUtils.deleteDirectory((File)new File(this.buildPeerDir(groupId)));
            return null;
        });
        if (!exist.get()) {
            return ConsensusGenericResponse.newBuilder().setException(new ConsensusGroupNotExistException(groupId)).build();
        }
        return ConsensusGenericResponse.newBuilder().setSuccess(true).build();
    }

    @Override
    public ConsensusGenericResponse addPeer(ConsensusGroupId groupId, Peer peer) {
        return ConsensusGenericResponse.newBuilder().setSuccess(false).build();
    }

    @Override
    public ConsensusGenericResponse removePeer(ConsensusGroupId groupId, Peer peer) {
        return ConsensusGenericResponse.newBuilder().setSuccess(false).build();
    }

    @Override
    public ConsensusGenericResponse updatePeer(ConsensusGroupId groupId, Peer oldPeer, Peer newPeer) {
        return ConsensusGenericResponse.newBuilder().setSuccess(false).build();
    }

    @Override
    public ConsensusGenericResponse changePeer(ConsensusGroupId groupId, List<Peer> newPeers) {
        return ConsensusGenericResponse.newBuilder().setSuccess(false).build();
    }

    @Override
    public ConsensusGenericResponse transferLeader(ConsensusGroupId groupId, Peer newLeader) {
        return ConsensusGenericResponse.newBuilder().setSuccess(false).build();
    }

    @Override
    public ConsensusGenericResponse triggerSnapshot(ConsensusGroupId groupId) {
        return ConsensusGenericResponse.newBuilder().setSuccess(false).build();
    }

    @Override
    public boolean isLeader(ConsensusGroupId groupId) {
        return true;
    }

    @Override
    public Peer getLeader(ConsensusGroupId groupId) {
        if (!this.stateMachineMap.containsKey(groupId)) {
            return null;
        }
        return new Peer(groupId, this.thisNodeId, this.thisNode);
    }

    @Override
    public List<ConsensusGroupId> getAllConsensusGroupIds() {
        return new ArrayList<ConsensusGroupId>(this.stateMachineMap.keySet());
    }

    private String buildPeerDir(ConsensusGroupId groupId) {
        return this.storageDir + File.separator + groupId.getType().getValue() + "_" + groupId.getId();
    }
}

