/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe.task;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.SetPipeStatusPlanV2;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.pipe.AbstractOperatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopPipeProcedureV2
extends AbstractOperatePipeProcedureV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(StopPipeProcedureV2.class);
    private String pipeName;

    public StopPipeProcedureV2() {
    }

    public StopPipeProcedureV2(String pipeName) throws PipeException {
        this.pipeName = pipeName;
    }

    @Override
    protected PipeTaskOperation getOperation() {
        return PipeTaskOperation.STOP_PIPE;
    }

    @Override
    protected void executeFromValidateTask(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("StopPipeProcedureV2: executeFromValidateTask({})", (Object)this.pipeName);
        ((PipeTaskInfo)this.pipeTaskInfo.get()).checkBeforeStopPipe(this.pipeName);
    }

    @Override
    protected void executeFromCalculateInfoForTask(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("StopPipeProcedureV2: executeFromCalculateInfoForTask({})", (Object)this.pipeName);
    }

    @Override
    protected void executeFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("StopPipeProcedureV2: executeFromWriteConfigNodeConsensus({})", (Object)this.pipeName);
        ConsensusWriteResponse response = env.getConfigManager().getConsensusManager().write(new SetPipeStatusPlanV2(this.pipeName, PipeStatus.STOPPED));
        if (!response.isSuccessful()) {
            throw new PipeException(response.getErrorMessage());
        }
    }

    @Override
    protected void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws PipeException, IOException {
        LOGGER.info("StopPipeProcedureV2: executeFromOperateOnDataNodes({})", (Object)this.pipeName);
        String exceptionMessage = this.parsePushPipeMetaExceptionForPipe(this.pipeName, this.pushPipeMetaToDataNodes(env));
        if (!exceptionMessage.isEmpty()) {
            throw new PipeException(String.format("Failed to stop pipe %s, details: %s", this.pipeName, exceptionMessage));
        }
    }

    @Override
    protected void rollbackFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("StopPipeProcedureV2: rollbackFromValidateTask({})", (Object)this.pipeName);
    }

    @Override
    protected void rollbackFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("StopPipeProcedureV2: rollbackFromCalculateInfoForTask({})", (Object)this.pipeName);
    }

    @Override
    protected void rollbackFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        LOGGER.info("StopPipeProcedureV2: rollbackFromWriteConfigNodeConsensus({})", (Object)this.pipeName);
        ConsensusWriteResponse response = env.getConfigManager().getConsensusManager().write(new SetPipeStatusPlanV2(this.pipeName, PipeStatus.RUNNING));
        if (!response.isSuccessful()) {
            throw new PipeException(response.getErrorMessage());
        }
    }

    @Override
    protected void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws PipeException, IOException {
        LOGGER.info("StopPipeProcedureV2: rollbackFromOperateOnDataNodes({})", (Object)this.pipeName);
        String exceptionMessage = this.parsePushPipeMetaExceptionForPipe(this.pipeName, this.pushPipeMetaToDataNodes(env));
        if (!exceptionMessage.isEmpty()) {
            throw new PipeException(String.format("Failed to rollback stop pipe %s, details: %s", this.pipeName, exceptionMessage));
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.STOP_PIPE_PROCEDURE_V2.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.pipeName, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.pipeName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StopPipeProcedureV2 that = (StopPipeProcedureV2)o;
        return this.pipeName.equals(that.pipeName);
    }

    public int hashCode() {
        return this.pipeName.hashCode();
    }
}

