/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.model.exception.ModelManagementException;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.sync.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.consensus.request.write.model.DropModelPlan;
import org.apache.iotdb.confignode.persistence.ModelInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.model.DropModelState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.db.protocol.client.MLNodeClient;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteModelMetricsReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropModelProcedure
extends AbstractNodeProcedure<DropModelState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropModelProcedure.class);
    private static final int RETRY_THRESHOLD = 1;
    private String modelId;

    public DropModelProcedure() {
    }

    public DropModelProcedure(String modelId) {
        this.modelId = modelId;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, DropModelState state) {
        block23: {
            if (this.modelId == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case INIT: {
                        LOGGER.info("Start to drop model [{}]", (Object)this.modelId);
                        ModelInfo modelInfo = env.getConfigManager().getModelManager().getModelInfo();
                        modelInfo.acquireModelTableLock();
                        if (!modelInfo.isModelExist(this.modelId)) {
                            throw new ModelManagementException(String.format("Failed to drop model [%s], this model has not been created", this.modelId));
                        }
                        this.setNextState(DropModelState.VALIDATED);
                        break;
                    }
                    case VALIDATED: {
                        LOGGER.info("Start to drop model metrics [{}] on Data Nodes", (Object)this.modelId);
                        Optional<TDataNodeLocation> targetDataNode = env.getConfigManager().getNodeManager().getLowestLoadDataNode();
                        if (!targetDataNode.isPresent()) {
                            throw new ModelManagementException(String.format("Failed to drop model [%s], there is no RUNNING DataNode", this.modelId));
                        }
                        TSStatus status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(targetDataNode.get().getInternalEndPoint(), new TDeleteModelMetricsReq(this.modelId), DataNodeRequestType.DELETE_MODEL_METRICS);
                        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            throw new ModelManagementException(String.format("Failed to drop model [%s], fail to delete metrics: %s", this.modelId, status.getMessage()));
                        }
                        this.setNextState(DropModelState.DATA_NODE_DROPPED);
                        break;
                    }
                    case DATA_NODE_DROPPED: {
                        LOGGER.info("Start to drop model file [{}] on Ml Node", (Object)this.modelId);
                        try (MLNodeClient client = new MLNodeClient();){
                            TSStatus status = client.deleteModel(this.modelId);
                            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                                throw new TException(status.getMessage());
                            }
                        }
                        catch (TException e) {
                            throw new ModelManagementException(String.format("Failed to drop model [%s], fail to delete model on MLNode: %s", this.modelId, e.getMessage()));
                        }
                        this.setNextState(DropModelState.ML_NODE_DROPPED);
                        break;
                    }
                    case ML_NODE_DROPPED: {
                        LOGGER.info("Start to drop model [{}] on Config Nodes", (Object)this.modelId);
                        ConsensusWriteResponse response = env.getConfigManager().getConsensusManager().write(new DropModelPlan(this.modelId));
                        if (!response.isSuccessful()) {
                            throw new ModelManagementException(String.format("Failed to drop model [%s], fail to drop model on Config Nodes: %s", this.modelId, response.getErrorMessage()));
                        }
                        this.setNextState(DropModelState.CONFIG_NODE_DROPPED);
                        break;
                    }
                    case CONFIG_NODE_DROPPED: {
                        env.getConfigManager().getModelManager().getModelInfo().releaseModelTableLock();
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    LOGGER.error("Fail in DropModelProcedure", (Throwable)e);
                    this.setFailure(new ProcedureException(e.getMessage()));
                }
                LOGGER.error("Retrievable error trying to drop model [{}], state [{}]", new Object[]{this.modelId, state, e});
                if (this.getCycles() <= 1) break block23;
                this.setFailure(new ProcedureException(String.format("Fail to drop model [%s] at STATE [%s], %s", new Object[]{this.modelId, state, e.getMessage()})));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, DropModelState state) throws IOException, InterruptedException, ProcedureException {
        if (state == DropModelState.INIT) {
            LOGGER.info("Start [INIT] rollback of model [{}]", (Object)this.modelId);
            env.getConfigManager().getModelManager().getModelInfo().releaseModelTableLock();
        }
    }

    @Override
    protected DropModelState getState(int stateId) {
        return DropModelState.values()[stateId];
    }

    @Override
    protected int getStateId(DropModelState dropModelState) {
        return dropModelState.ordinal();
    }

    @Override
    protected DropModelState getInitialState() {
        return DropModelState.INIT;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.DROP_MODEL_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.modelId, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.modelId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object that) {
        if (that instanceof DropModelProcedure) {
            DropModelProcedure thatProc = (DropModelProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.modelId.equals(this.modelId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getProcId(), this.getState(), this.modelId});
    }
}

