/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.quotas;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetThrottleQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TThrottleQuota;
import org.apache.iotdb.commons.exception.RpcThrottlingException;
import org.apache.iotdb.confignode.rpc.thrift.TThrottleQuotaResp;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.ClusterConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.storageengine.rescon.quotas.DefaultOperationQuota;
import org.apache.iotdb.db.storageengine.rescon.quotas.NoopOperationQuota;
import org.apache.iotdb.db.storageengine.rescon.quotas.OperationQuota;
import org.apache.iotdb.db.storageengine.rescon.quotas.QuotaLimiter;
import org.apache.iotdb.db.storageengine.rescon.quotas.ThrottleQuotaLimit;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeThrottleQuotaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeThrottleQuotaManager.class);
    private ThrottleQuotaLimit throttleQuotaLimit = new ThrottleQuotaLimit();

    public DataNodeThrottleQuotaManager() {
        this.recover();
    }

    public static DataNodeThrottleQuotaManager getInstance() {
        return DataNodeThrottleQuotaManagerHolder.INSTANCE;
    }

    public TSStatus setThrottleQuota(TSetThrottleQuotaReq req) {
        this.throttleQuotaLimit.setQuotas(req);
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public ThrottleQuotaLimit getThrottleQuotaLimit() {
        return this.throttleQuotaLimit;
    }

    public void setThrottleQuotaLimit(ThrottleQuotaLimit throttleQuotaLimit) {
        this.throttleQuotaLimit = throttleQuotaLimit;
    }

    public OperationQuota checkQuota(String userName, Statement s) throws RpcThrottlingException {
        if (!IoTDBDescriptor.getInstance().getConfig().isQuotaEnable()) {
            return NoopOperationQuota.get();
        }
        switch (s.getType()) {
            case INSERT: 
            case BATCH_INSERT: 
            case BATCH_INSERT_ONE_DEVICE: 
            case BATCH_INSERT_ROWS: 
            case MULTI_BATCH_INSERT: {
                return this.checkQuota(userName, 1, 0, s);
            }
            case QUERY: 
            case GROUP_BY_TIME: 
            case QUERY_INDEX: 
            case AGGREGATION: 
            case UDAF: 
            case UDTF: 
            case LAST: 
            case FILL: 
            case GROUP_BY_FILL: 
            case SELECT_INTO: {
                return this.checkQuota(userName, 0, 1, s);
            }
        }
        return NoopOperationQuota.get();
    }

    private OperationQuota checkQuota(String userName, int numWrites, int numReads, Statement s) throws RpcThrottlingException {
        OperationQuota quota = this.getQuota(userName);
        quota.checkQuota(numWrites, numReads, s);
        return quota;
    }

    private OperationQuota getQuota(String userName) {
        QuotaLimiter userLimiter = this.throttleQuotaLimit.getUserLimiter(userName);
        if (userLimiter != null) {
            return new DefaultOperationQuota(userLimiter);
        }
        return NoopOperationQuota.get();
    }

    private void recover() {
        TThrottleQuotaResp throttleQuota = ClusterConfigTaskExecutor.getInstance().getThrottleQuota();
        if (throttleQuota.getStatus() != null) {
            if (throttleQuota.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && throttleQuota.getThrottleQuota() != null) {
                for (String userName : throttleQuota.getThrottleQuota().keySet()) {
                    TSetThrottleQuotaReq req = new TSetThrottleQuotaReq();
                    req.setUserName(userName);
                    req.setThrottleQuota((TThrottleQuota)throttleQuota.getThrottleQuota().get(userName));
                    this.setThrottleQuota(req);
                }
            }
            LOGGER.info("Throttle quota limit restored successfully. " + throttleQuota);
        } else {
            LOGGER.info("Throttle quota limit restored failed. " + throttleQuota);
        }
    }

    private static class DataNodeThrottleQuotaManagerHolder {
        private static final DataNodeThrottleQuotaManager INSTANCE = new DataNodeThrottleQuotaManager();

        private DataNodeThrottleQuotaManagerHolder() {
        }
    }
}

