/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.AlignedChunkReader;

public class DiskAlignedChunkLoader
implements IChunkLoader {
    private final boolean debug;
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();

    public DiskAlignedChunkLoader(boolean debug) {
        this.debug = debug;
    }

    public Chunk loadChunk(ChunkMetadata chunkMetaData) {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChunkReader getChunkReader(IChunkMetadata chunkMetaData, Filter timeFilter) throws IOException {
        long t1 = System.nanoTime();
        try {
            AlignedChunkMetadata alignedChunkMetadata = (AlignedChunkMetadata)chunkMetaData;
            Chunk timeChunk = ChunkCache.getInstance().get((ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata(), this.debug);
            ArrayList<Chunk> valueChunkList = new ArrayList<Chunk>();
            for (IChunkMetadata valueChunkMetadata : alignedChunkMetadata.getValueChunkMetadataList()) {
                valueChunkList.add(valueChunkMetadata == null ? null : ChunkCache.getInstance().get((ChunkMetadata)valueChunkMetadata, this.debug));
            }
            long t2 = System.nanoTime();
            AlignedChunkReader chunkReader = new AlignedChunkReader(timeChunk, valueChunkList, timeFilter);
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("init_chunk_reader_aligned_disk", System.nanoTime() - t2);
            AlignedChunkReader alignedChunkReader = chunkReader;
            return alignedChunkReader;
        }
        finally {
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("construct_chunk_reader_aligned_disk", System.nanoTime() - t1);
        }
    }
}

