/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionIoDataType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.TsFileDeviceIterator;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.utils.Pair;

public class CompactionTsFileReader
extends TsFileSequenceReader {
    private AtomicLong readDataSize = new AtomicLong(0L);
    CompactionType compactionType;
    private volatile boolean readingAlignedSeries = false;

    public CompactionTsFileReader(String file, CompactionType compactionType) throws IOException {
        super(file);
        this.compactionType = compactionType;
    }

    protected ByteBuffer readData(long position, int totalSize) throws IOException {
        ByteBuffer buffer = super.readData(position, totalSize);
        this.readDataSize.addAndGet(totalSize);
        return buffer;
    }

    public void markStartOfAlignedSeries() {
        this.readingAlignedSeries = true;
    }

    public void markEndOfAlignedSeries() {
        this.readingAlignedSeries = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk readMemChunk(ChunkMetadata metaData) throws IOException {
        CompactionTsFileReader compactionTsFileReader = this;
        synchronized (compactionTsFileReader) {
            long before = this.readDataSize.get();
            Chunk chunk = super.readMemChunk(metaData);
            long dataSize = this.readDataSize.get() - before;
            CompactionMetrics.getInstance().recordReadInfo(this.compactionType, this.readingAlignedSeries ? CompactionIoDataType.ALIGNED : CompactionIoDataType.NOT_ALIGNED, dataSize);
            return chunk;
        }
    }

    public TsFileDeviceIterator getAllDevicesIteratorWithIsAligned() throws IOException {
        long before = this.readDataSize.get();
        TsFileDeviceIterator iterator = super.getAllDevicesIteratorWithIsAligned();
        long dataSize = this.readDataSize.get() - before;
        CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, dataSize);
        return iterator;
    }

    public List<IChunkMetadata> getChunkMetadataListByTimeseriesMetadataOffset(long startOffset, long endOffset) throws IOException {
        long before = this.readDataSize.get();
        List chunkMetadataList = super.getChunkMetadataListByTimeseriesMetadataOffset(startOffset, endOffset);
        long dataSize = this.readDataSize.get() - before;
        CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, dataSize);
        return chunkMetadataList;
    }

    public void getDevicesAndEntriesOfOneLeafNode(Long startOffset, Long endOffset, Queue<Pair<String, long[]>> measurementNodeOffsetQueue) throws IOException {
        long before = this.readDataSize.get();
        super.getDevicesAndEntriesOfOneLeafNode(startOffset, endOffset, measurementNodeOffsetQueue);
        long dataSize = this.readDataSize.get() - before;
        CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, dataSize);
    }

    public MetadataIndexNode readMetadataIndexNode(long start, long end) throws IOException {
        long before = this.readDataSize.get();
        MetadataIndexNode metadataIndexNode = super.readMetadataIndexNode(start, end);
        long dataSize = this.readDataSize.get() - before;
        CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, dataSize);
        return metadataIndexNode;
    }

    public Map<String, Pair<List<IChunkMetadata>, Pair<Long, Long>>> getTimeseriesMetadataOffsetByDevice(MetadataIndexNode measurementNode, Set<String> excludedMeasurementIds, boolean needChunkMetadata) throws IOException {
        long before = this.readDataSize.get();
        Map result = super.getTimeseriesMetadataOffsetByDevice(measurementNode, excludedMeasurementIds, needChunkMetadata);
        long dataSize = this.readDataSize.get() - before;
        CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, dataSize);
        return result;
    }

    public void getDeviceTimeseriesMetadata(List<TimeseriesMetadata> timeseriesMetadataList, MetadataIndexNode measurementNode, Set<String> excludedMeasurementIds, boolean needChunkMetadata) throws IOException {
        long before = this.readDataSize.get();
        super.getDeviceTimeseriesMetadata(timeseriesMetadataList, measurementNode, excludedMeasurementIds, needChunkMetadata);
        long dataSize = this.readDataSize.get() - before;
        CompactionMetrics.getInstance().recordReadInfo(this.compactionType, CompactionIoDataType.METADATA, dataSize);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

