/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.template;

import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class DeactivateTemplateStatement
extends Statement
implements IConfigStatement {
    private String templateName;
    private List<PartialPath> pathPatternList;

    public DeactivateTemplateStatement() {
        this.statementType = StatementType.DEACTIVATE_TEMPLATE;
    }

    public DeactivateTemplateStatement(String templateName, List<PartialPath> pathPatternList) {
        this.templateName = templateName;
        this.pathPatternList = pathPatternList;
        this.statementType = StatementType.DEACTIVATE_TEMPLATE;
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.getPathPatternList();
    }

    public String getTemplateName() {
        return this.templateName == null ? "*" : this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public List<PartialPath> getPathPatternList() {
        return this.pathPatternList;
    }

    public void setPathPatternList(List<PartialPath> pathPatternList) {
        this.pathPatternList = pathPatternList;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitDeactivateTemplate(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }
}

