/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.scheduler.load;

import io.airlift.units.Duration;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.ExecutorType;
import org.apache.iotdb.commons.partition.StorageExecutor;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.mpp.FragmentInstanceDispatchException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.execution.QueryStateMachine;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInfo;
import org.apache.iotdb.db.queryengine.execution.load.ChunkData;
import org.apache.iotdb.db.queryengine.execution.load.TsFileData;
import org.apache.iotdb.db.queryengine.execution.load.TsFileSplitter;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadSingleTsFileNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadTsFilePieceNode;
import org.apache.iotdb.db.queryengine.plan.scheduler.FragInstanceDispatchResult;
import org.apache.iotdb.db.queryengine.plan.scheduler.IScheduler;
import org.apache.iotdb.db.queryengine.plan.scheduler.load.LoadTsFileDispatcherImpl;
import org.apache.iotdb.mpp.rpc.thrift.TLoadCommandReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileScheduler
implements IScheduler {
    private static final Logger logger = LoggerFactory.getLogger(LoadTsFileScheduler.class);
    public static final long LOAD_TASK_MAX_TIME_IN_SECOND = 5184000L;
    private static final long MAX_MEMORY_SIZE;
    private static final int TRANSMIT_LIMIT;
    private final MPPQueryContext queryContext;
    private final QueryStateMachine stateMachine;
    private final LoadTsFileDispatcherImpl dispatcher;
    private final DataPartitionBatchFetcher partitionFetcher;
    private final List<LoadSingleTsFileNode> tsFileNodeList;
    private final PlanFragmentId fragmentId;
    private Set<TRegionReplicaSet> allReplicaSets;

    public LoadTsFileScheduler(DistributedQueryPlan distributedQueryPlan, MPPQueryContext queryContext, QueryStateMachine stateMachine, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager, IPartitionFetcher partitionFetcher) {
        this.queryContext = queryContext;
        this.stateMachine = stateMachine;
        this.tsFileNodeList = new ArrayList<LoadSingleTsFileNode>();
        this.fragmentId = distributedQueryPlan.getRootSubPlan().getPlanFragment().getId();
        this.dispatcher = new LoadTsFileDispatcherImpl(internalServiceClientManager);
        this.partitionFetcher = new DataPartitionBatchFetcher(partitionFetcher);
        this.allReplicaSets = new HashSet<TRegionReplicaSet>();
        for (FragmentInstance fragmentInstance : distributedQueryPlan.getInstances()) {
            this.tsFileNodeList.add((LoadSingleTsFileNode)fragmentInstance.getFragment().getPlanNodeTree());
        }
    }

    @Override
    public void start() {
        this.stateMachine.transitionToRunning();
        int tsFileNodeListSize = this.tsFileNodeList.size();
        boolean isLoadSuccess = true;
        for (int i = 0; i < tsFileNodeListSize; ++i) {
            LoadSingleTsFileNode node = this.tsFileNodeList.get(i);
            boolean isLoadSingleTsFileSuccess = true;
            try {
                if (node.isTsFileEmpty()) {
                    logger.info("Load skip TsFile {}, because it has no data.", (Object)node.getTsFileResource().getTsFilePath());
                } else if (!node.needDecodeTsFile(this.partitionFetcher::queryDataPartition)) {
                    isLoadSingleTsFileSuccess = this.loadLocally(node);
                    node.clean();
                } else {
                    String uuid = UUID.randomUUID().toString();
                    this.dispatcher.setUuid(uuid);
                    this.allReplicaSets.clear();
                    boolean isFirstPhaseSuccess = this.firstPhase(node);
                    boolean isSecondPhaseSuccess = this.secondPhase(isFirstPhaseSuccess, uuid, node.getTsFileResource().getTsFile());
                    node.clean();
                    if (!isFirstPhaseSuccess || !isSecondPhaseSuccess) {
                        isLoadSingleTsFileSuccess = false;
                    }
                }
                if (isLoadSingleTsFileSuccess) {
                    logger.info("Load TsFile {} Successfully, load process [{}/{}]", new Object[]{node.getTsFileResource().getTsFilePath(), i + 1, tsFileNodeListSize});
                    continue;
                }
                isLoadSuccess = false;
                logger.warn("Can not Load TsFile {}, load process [{}/{}]", new Object[]{node.getTsFileResource().getTsFilePath(), i + 1, tsFileNodeListSize});
                continue;
            }
            catch (Exception e) {
                isLoadSuccess = false;
                this.stateMachine.transitionToFailed(e);
                logger.warn(String.format("LoadTsFileScheduler loads TsFile %s error", node.getTsFileResource().getTsFilePath()), (Throwable)e);
            }
        }
        if (isLoadSuccess) {
            this.stateMachine.transitionToFinished();
        }
    }

    private boolean firstPhase(LoadSingleTsFileNode node) {
        try {
            TsFileDataManager tsFileDataManager = new TsFileDataManager(this, node);
            new TsFileSplitter(node.getTsFileResource().getTsFile(), x$0 -> tsFileDataManager.addOrSendTsFileData(x$0)).splitTsFileByDataPartition();
            if (!tsFileDataManager.sendAllTsFileData()) {
                this.stateMachine.transitionToFailed(new TSStatus(TSStatusCode.LOAD_FILE_ERROR.getStatusCode()));
                return false;
            }
        }
        catch (IllegalStateException e) {
            this.stateMachine.transitionToFailed(e);
            logger.warn(String.format("Dispatch TsFileData error when parsing TsFile %s.", node.getTsFileResource().getTsFile()), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            this.stateMachine.transitionToFailed(e);
            logger.warn(String.format("Parse or send TsFile %s error.", node.getTsFileResource().getTsFile()), (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean dispatchOnePieceNode(LoadTsFilePieceNode pieceNode, TRegionReplicaSet replicaSet) {
        this.allReplicaSets.add(replicaSet);
        FragmentInstance instance = new FragmentInstance(new PlanFragment(this.fragmentId, pieceNode), this.fragmentId.genFragmentInstanceId(), null, this.queryContext.getQueryType(), this.queryContext.getTimeOut(), this.queryContext.getSession());
        instance.setExecutorAndHost((ExecutorType)new StorageExecutor(replicaSet));
        Future<FragInstanceDispatchResult> dispatchResultFuture = this.dispatcher.dispatch(Collections.singletonList(instance));
        try {
            FragInstanceDispatchResult result = dispatchResultFuture.get(5184000L, TimeUnit.SECONDS);
            if (!result.isSuccessful()) {
                logger.warn("Dispatch one piece to ReplicaSet {} error. Result status code {}. Result status message {}. Dispatch piece node error:%n{}", new Object[]{replicaSet, TSStatusCode.representOf((int)result.getFailureStatus().getCode()).name(), result.getFailureStatus().getMessage(), pieceNode});
                if (result.getFailureStatus().getSubStatus() != null) {
                    for (TSStatus status : result.getFailureStatus().getSubStatus()) {
                        logger.warn("Sub status code {}. Sub status message {}.", (Object)TSStatusCode.representOf((int)status.getCode()).name(), (Object)status.getMessage());
                    }
                }
                TSStatus status = result.getFailureStatus();
                status.setMessage(String.format("Load %s piece error in 1st phase. Because ", pieceNode.getTsFile()) + status.getMessage());
                this.stateMachine.transitionToFailed(status);
                return false;
            }
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.warn("Interrupt or Execution error.", (Throwable)e);
            this.stateMachine.transitionToFailed(e);
            return false;
        }
        catch (TimeoutException e) {
            dispatchResultFuture.cancel(true);
            logger.warn(String.format("Wait for loading %s time out.", LoadTsFilePieceNode.class.getName()), (Throwable)e);
            this.stateMachine.transitionToFailed(e);
            return false;
        }
        return true;
    }

    private boolean secondPhase(boolean isFirstPhaseSuccess, String uuid, File tsFile) {
        logger.info("Start dispatching Load command for uuid {}", (Object)uuid);
        TLoadCommandReq loadCommandReq = new TLoadCommandReq((isFirstPhaseSuccess ? LoadCommand.EXECUTE : LoadCommand.ROLLBACK).ordinal(), uuid);
        Future<FragInstanceDispatchResult> dispatchResultFuture = this.dispatcher.dispatchCommand(loadCommandReq, this.allReplicaSets);
        try {
            FragInstanceDispatchResult result = dispatchResultFuture.get();
            if (!result.isSuccessful()) {
                logger.warn("Dispatch load command {} of TsFile {} error to replicaSets {} error. Result status code {}. Result status message {}.", new Object[]{loadCommandReq, tsFile, this.allReplicaSets, TSStatusCode.representOf((int)result.getFailureStatus().getCode()).name(), result.getFailureStatus().getMessage()});
                TSStatus status = result.getFailureStatus();
                status.setMessage(String.format("Load %s error in 2nd phase. Because ", tsFile) + status.getMessage());
                this.stateMachine.transitionToFailed(status);
                return false;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.warn("Interrupt or Execution error.", (Throwable)e);
            this.stateMachine.transitionToFailed(e);
            return false;
        }
        return true;
    }

    private boolean loadLocally(LoadSingleTsFileNode node) {
        logger.info("Start load TsFile {} locally.", (Object)node.getTsFileResource().getTsFile().getPath());
        try {
            FragmentInstance instance = new FragmentInstance(new PlanFragment(this.fragmentId, node), this.fragmentId.genFragmentInstanceId(), null, this.queryContext.getQueryType(), this.queryContext.getTimeOut(), this.queryContext.getSession());
            instance.setExecutorAndHost((ExecutorType)new StorageExecutor(node.getLocalRegionReplicaSet()));
            this.dispatcher.dispatchLocally(instance);
        }
        catch (FragmentInstanceDispatchException e) {
            logger.warn(String.format("Dispatch tsFile %s error to local error. Result status code %s. Result status message %s.", node.getTsFileResource().getTsFile(), TSStatusCode.representOf((int)e.getFailureStatus().getCode()).name(), e.getFailureStatus().getMessage()));
            this.stateMachine.transitionToFailed(e.getFailureStatus());
            return false;
        }
        return true;
    }

    @Override
    public void stop(Throwable t) {
    }

    @Override
    public Duration getTotalCpuTime() {
        return null;
    }

    @Override
    public FragmentInfo getFragmentInfo() {
        return null;
    }

    static {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        MAX_MEMORY_SIZE = Math.min((long)(config.getThriftMaxFrameSize() >> 2), (long)((double)config.getAllocateMemoryForStorageEngine() * config.getLoadTsFileProportion()));
        TRANSMIT_LIMIT = CommonDescriptor.getInstance().getConfig().getTTimePartitionSlotTransmitLimit();
    }

    private static class DataPartitionBatchFetcher {
        private final IPartitionFetcher fetcher;

        public DataPartitionBatchFetcher(IPartitionFetcher fetcher) {
            this.fetcher = fetcher;
        }

        public List<TRegionReplicaSet> queryDataPartition(List<Pair<String, TTimePartitionSlot>> slotList) {
            ArrayList<TRegionReplicaSet> replicaSets = new ArrayList<TRegionReplicaSet>();
            int size = slotList.size();
            for (int i = 0; i < size; i += TRANSMIT_LIMIT) {
                List<Pair<String, TTimePartitionSlot>> subSlotList = slotList.subList(i, Math.min(size, i + TRANSMIT_LIMIT));
                DataPartition dataPartition = this.fetcher.getOrCreateDataPartition(this.toQueryParam(subSlotList));
                replicaSets.addAll(subSlotList.stream().map(pair -> dataPartition.getDataRegionReplicaSetForWriting((String)pair.left, (TTimePartitionSlot)pair.right)).collect(Collectors.toList()));
            }
            return replicaSets;
        }

        private List<DataPartitionQueryParam> toQueryParam(List<Pair<String, TTimePartitionSlot>> slots) {
            return slots.stream().collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toSet()))).entrySet().stream().map(entry -> new DataPartitionQueryParam((String)entry.getKey(), new ArrayList((Collection)entry.getValue()))).collect(Collectors.toList());
        }
    }

    private static class TsFileDataManager {
        private final LoadTsFileScheduler scheduler;
        private final LoadSingleTsFileNode singleTsFileNode;
        private long dataSize;
        private final Map<TRegionReplicaSet, LoadTsFilePieceNode> replicaSet2Piece;
        private final List<ChunkData> nonDirectionalChunkData;

        public TsFileDataManager(LoadTsFileScheduler scheduler, LoadSingleTsFileNode singleTsFileNode) {
            this.scheduler = scheduler;
            this.singleTsFileNode = singleTsFileNode;
            this.dataSize = 0L;
            this.replicaSet2Piece = new HashMap<TRegionReplicaSet, LoadTsFilePieceNode>();
            this.nonDirectionalChunkData = new ArrayList<ChunkData>();
        }

        private boolean addOrSendTsFileData(TsFileData tsFileData) {
            return tsFileData.isModification() ? this.addOrSendDeletionData(tsFileData) : this.addOrSendChunkData((ChunkData)tsFileData);
        }

        private boolean addOrSendChunkData(ChunkData chunkData) {
            this.nonDirectionalChunkData.add(chunkData);
            this.dataSize += chunkData.getDataSize();
            if (this.dataSize > MAX_MEMORY_SIZE) {
                TRegionReplicaSet sortedReplicaSet;
                LoadTsFilePieceNode pieceNode;
                this.routeChunkData();
                List sortedReplicaSets = this.replicaSet2Piece.keySet().stream().sorted(Comparator.comparingLong(o -> this.replicaSet2Piece.get(o).getDataSize()).reversed()).collect(Collectors.toList());
                Iterator iterator = sortedReplicaSets.iterator();
                while (iterator.hasNext() && (pieceNode = this.replicaSet2Piece.get(sortedReplicaSet = (TRegionReplicaSet)iterator.next())).getDataSize() != 0L) {
                    if (!this.scheduler.dispatchOnePieceNode(pieceNode, sortedReplicaSet)) {
                        return false;
                    }
                    this.dataSize -= pieceNode.getDataSize();
                    this.replicaSet2Piece.put(sortedReplicaSet, new LoadTsFilePieceNode(this.singleTsFileNode.getPlanNodeId(), this.singleTsFileNode.getTsFileResource().getTsFile()));
                    if (this.dataSize > MAX_MEMORY_SIZE) continue;
                    break;
                }
            }
            return true;
        }

        private void routeChunkData() {
            if (this.nonDirectionalChunkData.isEmpty()) {
                return;
            }
            List<TRegionReplicaSet> replicaSets = this.scheduler.partitionFetcher.queryDataPartition(this.nonDirectionalChunkData.stream().map(data -> new Pair((Object)data.getDevice(), (Object)data.getTimePartitionSlot())).collect(Collectors.toList()));
            IntStream.range(0, this.nonDirectionalChunkData.size()).forEach(i -> this.replicaSet2Piece.computeIfAbsent((TRegionReplicaSet)replicaSets.get(i), o -> new LoadTsFilePieceNode(this.singleTsFileNode.getPlanNodeId(), this.singleTsFileNode.getTsFileResource().getTsFile())).addTsFileData(this.nonDirectionalChunkData.get(i)));
            this.nonDirectionalChunkData.clear();
        }

        private boolean addOrSendDeletionData(TsFileData deletionData) {
            this.routeChunkData();
            for (Map.Entry<TRegionReplicaSet, LoadTsFilePieceNode> entry : this.replicaSet2Piece.entrySet()) {
                this.dataSize += deletionData.getDataSize();
                entry.getValue().addTsFileData(deletionData);
            }
            return true;
        }

        private boolean sendAllTsFileData() {
            this.routeChunkData();
            for (Map.Entry<TRegionReplicaSet, LoadTsFilePieceNode> entry : this.replicaSet2Piece.entrySet()) {
                if (this.scheduler.dispatchOnePieceNode(entry.getValue(), entry.getKey())) continue;
                logger.warn("Dispatch piece node {} of TsFile {} error.", (Object)entry.getValue(), (Object)this.singleTsFileNode.getTsFileResource().getTsFile());
                return false;
            }
            return true;
        }
    }

    public static enum LoadCommand {
        EXECUTE,
        ROLLBACK;

    }
}

