/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class InsertMultiTabletsNode
extends InsertNode {
    List<Integer> parentInsertTabletNodeIndexList;
    List<InsertTabletNode> insertTabletNodeList;
    private final Map<Integer, TSStatus> results = new HashMap<Integer, TSStatus>();

    public InsertMultiTabletsNode(PlanNodeId id) {
        super(id);
        this.parentInsertTabletNodeIndexList = new ArrayList<Integer>();
        this.insertTabletNodeList = new ArrayList<InsertTabletNode>();
    }

    public InsertMultiTabletsNode(PlanNodeId id, List<Integer> parentInsertTabletNodeIndexList, List<InsertTabletNode> insertTabletNodeList) {
        super(id);
        this.parentInsertTabletNodeIndexList = parentInsertTabletNodeIndexList;
        this.insertTabletNodeList = insertTabletNodeList;
    }

    public List<Integer> getParentInsertTabletNodeIndexList() {
        return this.parentInsertTabletNodeIndexList;
    }

    private void setParentInsertTabletNodeIndexList(List<Integer> parentInsertTabletNodeIndexList) {
        this.parentInsertTabletNodeIndexList = parentInsertTabletNodeIndexList;
    }

    public List<InsertTabletNode> getInsertTabletNodeList() {
        return this.insertTabletNodeList;
    }

    private void setInsertTabletNodeList(List<InsertTabletNode> insertTabletNodeList) {
        this.insertTabletNodeList = insertTabletNodeList;
    }

    public void addInsertTabletNode(InsertTabletNode node, Integer parentIndex) {
        this.insertTabletNodeList.add(node);
        this.parentInsertTabletNodeIndexList.add(parentIndex);
    }

    @Override
    public void setSearchIndex(long index) {
        this.searchIndex = index;
        this.insertTabletNodeList.forEach(plan -> plan.setSearchIndex(index));
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        HashMap<TRegionReplicaSet, InsertMultiTabletsNode> splitMap = new HashMap<TRegionReplicaSet, InsertMultiTabletsNode>();
        for (int i = 0; i < this.insertTabletNodeList.size(); ++i) {
            InsertTabletNode insertTabletNode = this.insertTabletNodeList.get(i);
            List<WritePlanNode> tmpResult = insertTabletNode.splitByPartition(analysis);
            for (WritePlanNode subNode : tmpResult) {
                TRegionReplicaSet dataRegionReplicaSet = ((InsertNode)subNode).getDataRegionReplicaSet();
                InsertMultiTabletsNode tmpNode = (InsertMultiTabletsNode)splitMap.get(dataRegionReplicaSet);
                if (tmpNode != null) {
                    tmpNode.addInsertTabletNode((InsertTabletNode)subNode, i);
                    continue;
                }
                tmpNode = new InsertMultiTabletsNode(this.getPlanNodeId());
                tmpNode.setDataRegionReplicaSet(dataRegionReplicaSet);
                tmpNode.addInsertTabletNode((InsertTabletNode)subNode, i);
                splitMap.put(dataRegionReplicaSet, tmpNode);
            }
        }
        return new ArrayList<WritePlanNode>(splitMap.values());
    }

    public Map<Integer, TSStatus> getResults() {
        return this.results;
    }

    public TSStatus[] getFailingStatus() {
        return StatusUtils.getFailingStatus(this.results, (int)this.insertTabletNodeList.size());
    }

    @Override
    public List<PlanNode> getChildren() {
        return null;
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("clone of Insert is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    public static InsertMultiTabletsNode deserialize(ByteBuffer byteBuffer) {
        int i;
        ArrayList<InsertTabletNode> insertTabletNodeList = new ArrayList<InsertTabletNode>();
        ArrayList<Integer> parentIndex = new ArrayList<Integer>();
        int size = byteBuffer.getInt();
        for (i = 0; i < size; ++i) {
            InsertTabletNode insertTabletNode = new InsertTabletNode(new PlanNodeId(""));
            insertTabletNode.subDeserialize(byteBuffer);
            insertTabletNodeList.add(insertTabletNode);
        }
        for (i = 0; i < size; ++i) {
            parentIndex.add(byteBuffer.getInt());
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        for (InsertTabletNode insertTabletNode : insertTabletNodeList) {
            insertTabletNode.setPlanNodeId(planNodeId);
        }
        InsertMultiTabletsNode insertMultiTabletsNode = new InsertMultiTabletsNode(planNodeId);
        insertMultiTabletsNode.setInsertTabletNodeList(insertTabletNodeList);
        insertMultiTabletsNode.setParentInsertTabletNodeIndexList(parentIndex);
        return insertMultiTabletsNode;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.INSERT_MULTI_TABLET.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.insertTabletNodeList.size(), (ByteBuffer)byteBuffer);
        for (InsertTabletNode node : this.insertTabletNodeList) {
            node.subSerialize(byteBuffer);
        }
        for (Integer index : this.parentInsertTabletNodeIndexList) {
            ReadWriteIOUtils.write((int)index, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.INSERT_MULTI_TABLET.serialize(stream);
        ReadWriteIOUtils.write((int)this.insertTabletNodeList.size(), (OutputStream)stream);
        for (InsertTabletNode node : this.insertTabletNodeList) {
            node.subSerialize(stream);
        }
        for (Integer index : this.parentInsertTabletNodeIndexList) {
            ReadWriteIOUtils.write((int)index, (OutputStream)stream);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertMultiTabletsNode that = (InsertMultiTabletsNode)o;
        return Objects.equals(this.parentInsertTabletNodeIndexList, that.parentInsertTabletNodeIndexList) && Objects.equals(this.insertTabletNodeList, that.insertTabletNodeList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parentInsertTabletNodeIndexList, this.insertTabletNodeList);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitInsertMultiTablets(this, context);
    }

    @Override
    public long getMinTime() {
        throw new NotImplementedException();
    }

    @Override
    public void setProgressIndex(ProgressIndex progressIndex) {
        this.progressIndex = progressIndex;
        this.insertTabletNodeList.forEach(node -> node.setProgressIndex(progressIndex));
    }
}

