/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryColumn;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.NullColumn;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.iotdb.tsfile.utils.Binary;

public class SingleDeviceViewOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final Operator deviceOperator;
    private final List<Integer> deviceColumnIndex;
    private final List<TSDataType> dataTypes;
    private final BinaryColumn binaryColumn;

    public SingleDeviceViewOperator(OperatorContext operatorContext, String device, Operator deviceOperator, List<Integer> deviceColumnIndex, List<TSDataType> dataTypes) {
        this.operatorContext = operatorContext;
        this.deviceOperator = deviceOperator;
        this.deviceColumnIndex = deviceColumnIndex;
        this.dataTypes = dataTypes;
        this.binaryColumn = new BinaryColumn(1, Optional.empty(), new Binary[]{new Binary(device)});
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ListenableFuture<?> blocked = this.deviceOperator.isBlocked();
        if (!blocked.isDone()) {
            return blocked;
        }
        return NOT_BLOCKED;
    }

    @Override
    public TsBlock next() throws Exception {
        int i;
        TsBlock tsBlock = this.deviceOperator.nextWithTimer();
        if (tsBlock == null) {
            return null;
        }
        Column[] newValueColumns = new Column[this.dataTypes.size()];
        for (i = 0; i < this.deviceColumnIndex.size(); ++i) {
            newValueColumns[this.deviceColumnIndex.get((int)i).intValue()] = tsBlock.getColumn(i);
        }
        newValueColumns[0] = new RunLengthEncodedColumn((Column)this.binaryColumn, tsBlock.getPositionCount());
        for (i = 0; i < this.dataTypes.size(); ++i) {
            if (newValueColumns[i] != null) continue;
            newValueColumns[i] = NullColumn.create((TSDataType)this.dataTypes.get(i), (int)tsBlock.getPositionCount());
        }
        return new TsBlock(tsBlock.getPositionCount(), tsBlock.getTimeColumn(), newValueColumns);
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.deviceOperator.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        this.deviceOperator.close();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = this.calculateMaxReturnSize() + this.calculateRetainedSizeAfterCallingNext();
        maxPeekMemory = Math.max(maxPeekMemory, this.deviceOperator.calculateMaxPeekMemory());
        return maxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        return (long)this.dataTypes.size() * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.deviceOperator.calculateRetainedSizeAfterCallingNext();
    }
}

