/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.subtask;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.execution.scheduler.PipeSubtaskScheduler;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeSubtask
implements FutureCallback<Boolean>,
Callable<Boolean>,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeSubtask.class);
    protected final String taskID;
    protected ListeningExecutorService subtaskWorkerThreadPoolExecutor;
    protected final AtomicBoolean shouldStopSubmittingSelf = new AtomicBoolean(true);
    protected PipeSubtaskScheduler subtaskScheduler;
    public static final int MAX_RETRY_TIMES = 5;
    protected final AtomicInteger retryCount = new AtomicInteger(0);
    protected Event lastEvent;

    protected PipeSubtask(String taskID) {
        this.taskID = taskID;
    }

    public abstract void bindExecutors(ListeningExecutorService var1, ExecutorService var2, PipeSubtaskScheduler var3);

    @Override
    public Boolean call() throws Exception {
        boolean hasAtLeastOneEventProcessed = false;
        while (this.subtaskScheduler.schedule() && this.executeOnce()) {
            hasAtLeastOneEventProcessed = true;
        }
        this.subtaskScheduler.reset();
        return hasAtLeastOneEventProcessed;
    }

    protected abstract boolean executeOnce() throws Exception;

    public void onSuccess(Boolean hasAtLeastOneEventProcessed) {
        this.retryCount.set(0);
        this.submitSelf();
    }

    public void onFailure(@NotNull Throwable throwable) {
        if (this.retryCount.get() == 0) {
            LOGGER.warn("Failed to execute subtask {}({}), because of {}. Will retry for {} times.", new Object[]{this.taskID, this.getClass().getSimpleName(), throwable.getMessage(), 5, throwable});
        }
        if (this.retryCount.get() < 5) {
            this.retryCount.incrementAndGet();
            LOGGER.warn("Retry executing subtask {}({}), retry count [{}/{}]", new Object[]{this.taskID, this.getClass().getSimpleName(), this.retryCount.get(), 5});
            this.submitSelf();
        } else {
            String errorMessage = String.format("Failed to execute subtask %s(%s), retry count exceeds the max retry times %d, last exception: %s, root cause: %s", this.taskID, this.getClass().getSimpleName(), this.retryCount.get(), throwable.getMessage(), ErrorHandlingUtils.getRootCause(throwable).getMessage());
            LOGGER.warn(errorMessage, throwable);
            if (this.lastEvent instanceof EnrichedEvent) {
                ((EnrichedEvent)this.lastEvent).reportException((PipeRuntimeException)(throwable instanceof PipeRuntimeException ? (PipeRuntimeException)throwable : new PipeRuntimeCriticalException(errorMessage)));
                LOGGER.warn("The last event is an instance of EnrichedEvent, so the exception is reported. Stopping current pipe task {}({}) locally... Status shown when query the pipe will be 'STOPPED'. Please restart the task by executing 'START PIPE' manually if needed.", new Object[]{this.taskID, this.getClass().getSimpleName(), throwable});
            } else {
                LOGGER.error("The last event is not an instance of EnrichedEvent, so the exception cannot be reported. Stopping current pipe task {}({}) locally... Status shown when query the pipe will be 'RUNNING' instead of 'STOPPED', but the task is actually stopped. Please restart the task by executing 'START PIPE' manually if needed.", new Object[]{this.taskID, this.getClass().getSimpleName(), throwable});
            }
        }
    }

    public abstract void submitSelf();

    public void allowSubmittingSelf() {
        this.retryCount.set(0);
        this.shouldStopSubmittingSelf.set(false);
    }

    public boolean disallowSubmittingSelf() {
        return !this.shouldStopSubmittingSelf.getAndSet(true);
    }

    public boolean isSubmittingSelf() {
        return !this.shouldStopSubmittingSelf.get();
    }

    @Override
    public synchronized void close() {
        this.releaseLastEvent();
    }

    protected void releaseLastEvent() {
        if (this.lastEvent != null) {
            if (this.lastEvent instanceof EnrichedEvent) {
                ((EnrichedEvent)this.lastEvent).decreaseReferenceCount(this.getClass().getName());
            }
            this.lastEvent = null;
        }
    }

    public String getTaskID() {
        return this.taskID;
    }

    public int getRetryCount() {
        return this.retryCount.get();
    }
}

