/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.util;

public class CircularQueue<E> {
    private static int INITCAP = 64;
    private int head = 0;
    private int tail = 0;
    private int size = 0;
    private int minLen;
    private E[] data;

    public CircularQueue(int capacity) {
        this.data = new Object[capacity];
        this.minLen = Math.max(INITCAP, capacity);
    }

    public CircularQueue() {
        this(INITCAP);
    }

    public void push(E value) {
        if (this.isFull()) {
            this.resize(this.data.length * 2);
        }
        this.data[this.tail] = value;
        this.tail = (this.tail + 1) % this.data.length;
        ++this.size;
    }

    public E pop() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Error: Queue is Empty!");
        }
        E ret = this.data[this.head];
        this.head = (this.head + 1) % this.data.length;
        --this.size;
        if (this.size < this.data.length / 4 && this.data.length / 2 >= this.minLen) {
            this.resize(this.data.length / 2);
        }
        return ret;
    }

    public E getHead() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Error: Queue is Empty!");
        }
        E ret = this.data[this.head];
        return ret;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size == this.data.length;
    }

    private void resize(int newLength) {
        Object[] newData = new Object[newLength];
        for (int i = 0; i < this.size; ++i) {
            newData[i] = this.data[(this.head + i) % this.data.length];
        }
        this.data = newData;
        this.head = 0;
        this.tail = this.size;
    }

    public E get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[(this.head + index) % this.data.length];
    }

    public int getSize() {
        return this.size;
    }
}

