/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair.util;

import java.util.ArrayList;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowIterator;
import org.apache.iotdb.udf.api.exception.UDFException;

public abstract class ValueFill {
    protected int n;
    protected long[] time;
    protected double[] original;
    protected double[] repaired;
    protected double mean = 0.0;
    protected double var = 0.0;
    protected int not_nan_number = 0;

    public ValueFill(RowIterator dataIterator) throws Exception {
        ArrayList<Long> timeList = new ArrayList<Long>();
        ArrayList<Double> originList = new ArrayList<Double>();
        while (dataIterator.hasNextRow()) {
            Row row = dataIterator.next();
            Double v = Util.getValueAsDouble(row);
            timeList.add(row.getTime());
            if (!Double.isFinite(v)) {
                originList.add(Double.NaN);
                continue;
            }
            originList.add(v);
        }
        this.time = Util.toLongArray(timeList);
        this.original = Util.toDoubleArray(originList);
        this.n = this.time.length;
        this.repaired = new double[this.n];
    }

    public abstract void fill() throws UDFException;

    public long[] getTime() {
        return this.time;
    }

    public double[] getFilled() {
        return this.repaired;
    }

    public void calMeanAndVar() throws UDFException {
        for (double v : this.original) {
            if (Double.isNaN(v)) continue;
            this.mean += v;
            ++this.not_nan_number;
        }
        if (this.not_nan_number == 0) {
            throw new UDFException("All values are NaN");
        }
        this.mean /= (double)this.not_nan_number;
        for (double v : this.original) {
            if (Double.isNaN(v)) continue;
            this.var += (v - this.mean) * (v - this.mean);
        }
        this.var /= (double)this.not_nan_number;
    }
}

