/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dquality.util;

import java.util.ArrayList;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowIterator;

public class TimeSeriesQuality {
    public static final int windowSize = 10;
    private boolean downtime = true;
    private int cnt = 0;
    private int missCnt = 0;
    private int specialCnt = 0;
    private int lateCnt = 0;
    private int redundancyCnt = 0;
    private int valueCnt = 0;
    private int variationCnt = 0;
    private int speedCnt = 0;
    private int speedchangeCnt = 0;
    private final double[] time;
    private final double[] origin;

    public TimeSeriesQuality(RowIterator dataIterator) throws Exception {
        ArrayList<Double> timeList = new ArrayList<Double>();
        ArrayList<Double> originList = new ArrayList<Double>();
        while (dataIterator.hasNextRow()) {
            Row row = dataIterator.next();
            ++this.cnt;
            double v = Util.getValueAsDouble(row);
            double t2 = row.getTime();
            if (Double.isFinite(v)) {
                timeList.add(t2);
                originList.add(v);
                continue;
            }
            ++this.specialCnt;
            timeList.add(t2);
            originList.add(Double.NaN);
        }
        this.time = Util.toDoubleArray(timeList);
        this.origin = Util.toDoubleArray(originList);
        this.processNaN();
    }

    private void processNaN() throws Exception {
        int i;
        int index2;
        int index1;
        int n = this.origin.length;
        for (index1 = 0; index1 < n && Double.isNaN(this.origin[index1]); ++index1) {
        }
        for (index2 = index1 + 1; index2 < n && Double.isNaN(this.origin[index2]); ++index2) {
        }
        if (index2 >= n) {
            throw new Exception("At least two non-NaN values are needed");
        }
        for (i = 0; i < index2; ++i) {
            this.origin[i] = this.origin[index1] + (this.origin[index2] - this.origin[index1]) * (this.time[i] - this.time[index1]) / (this.time[index2] - this.time[index1]);
        }
        for (i = index2 + 1; i < n; ++i) {
            if (Double.isNaN(this.origin[i])) continue;
            index1 = index2;
            index2 = i;
            for (int j = index1 + 1; j < index2; ++j) {
                this.origin[j] = this.origin[index1] + (this.origin[index2] - this.origin[index1]) * (this.time[j] - this.time[index1]) / (this.time[index2] - this.time[index1]);
            }
        }
        for (i = index2 + 1; i < n; ++i) {
            this.origin[i] = this.origin[index1] + (this.origin[index2] - this.origin[index1]) * (this.time[i] - this.time[index1]) / (this.time[index2] - this.time[index1]);
        }
    }

    public void timeDetect() {
        int i;
        double[] interval = Util.variation(this.time);
        Median median = new Median();
        double base = median.evaluate(interval);
        ArrayList<Double> window = new ArrayList<Double>();
        for (i = 0; i < Math.min(this.time.length, 10); ++i) {
            window.add(this.time[i]);
        }
        while (window.size() > 1) {
            double times = ((Double)window.get(1) - (Double)window.get(0)) / base;
            if (times <= 0.5) {
                window.remove(1);
                ++this.redundancyCnt;
            } else if (times >= 2.0 && (!this.downtime || times <= 9.0)) {
                double times2;
                int temp = 0;
                for (int j = 2; j < window.size() && !((times2 = ((Double)window.get(j) - (Double)window.get(j - 1)) / base) >= 2.0); ++j) {
                    if (!(times2 <= 0.5)) continue;
                    window.remove(j);
                    --j;
                    if (++temp == (int)Math.round(times - 1.0)) break;
                }
                this.lateCnt += temp;
                this.missCnt = (int)((long)this.missCnt + (Math.round(times - 1.0) - (long)temp));
            }
            window.remove(0);
            while (window.size() < 10 && i < this.time.length) {
                window.add(this.time[i]);
                ++i;
            }
        }
    }

    public void valueDetect() {
        int k = 3;
        this.valueCnt = this.findOutliers(this.origin, k);
        double[] variation = Util.variation(this.origin);
        this.variationCnt = this.findOutliers(variation, k);
        double[] speed = Util.speed(this.origin, this.time);
        this.speedCnt = this.findOutliers(speed, k);
        double[] speedchange = Util.variation(speed);
        this.speedchangeCnt = this.findOutliers(speedchange, k);
    }

    private int findOutliers(double[] value, double k) {
        Median median = new Median();
        double mid = median.evaluate(value);
        double sigma = Util.mad(value);
        int num = 0;
        for (double v : value) {
            if (!(Math.abs(v - mid) > k * sigma)) continue;
            ++num;
        }
        return num;
    }

    public double getCompleteness() {
        return 1.0 - (double)(this.missCnt + this.specialCnt) * 1.0 / (double)(this.cnt + this.missCnt);
    }

    public double getConsistency() {
        return 1.0 - (double)this.redundancyCnt * 1.0 / (double)this.cnt;
    }

    public double getTimeliness() {
        return 1.0 - (double)this.lateCnt * 1.0 / (double)this.cnt;
    }

    public double getValidity() {
        return 1.0 - (double)(this.valueCnt + this.variationCnt + this.speedCnt + this.speedchangeCnt) * 0.25 / (double)this.cnt;
    }

    public boolean isDowntime() {
        return this.downtime;
    }

    public void setDowntime(boolean downtime) {
        this.downtime = downtime;
    }
}

