/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import org.apache.iotdb.library.util.NoNumberException;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDAFSpread
implements UDTF {
    int intMin = Integer.MAX_VALUE;
    int intMax = Integer.MIN_VALUE;
    long longMin = Long.MAX_VALUE;
    long longMax = Long.MIN_VALUE;
    float floatMin = Float.MAX_VALUE;
    float floatMax = -3.4028235E38f;
    double doubleMin = Double.MAX_VALUE;
    double doubleMax = -1.7976931348623157E308;
    Type dataType;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        this.dataType = parameters.getDataType(0);
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(this.dataType);
    }

    @Override
    public void transform(Row row, PointCollector pc) throws Exception {
        switch (this.dataType) {
            case INT32: {
                this.transformInt(row, pc);
                break;
            }
            case INT64: {
                this.transformLong(row, pc);
                break;
            }
            case FLOAT: {
                this.transformFloat(row, pc);
                break;
            }
            case DOUBLE: {
                this.transformDouble(row, pc);
            }
        }
    }

    @Override
    public void terminate(PointCollector pc) throws Exception {
        switch (this.dataType) {
            case INT32: {
                pc.putInt(0L, this.intMax - this.intMin);
                break;
            }
            case INT64: {
                pc.putLong(0L, this.longMax - this.longMin);
                break;
            }
            case FLOAT: {
                pc.putFloat(0L, this.floatMax - this.floatMin);
                break;
            }
            case DOUBLE: {
                pc.putDouble(0L, this.doubleMax - this.doubleMin);
                break;
            }
            default: {
                throw new NoNumberException();
            }
        }
    }

    private void transformInt(Row row, PointCollector pc) throws Exception {
        int v = row.getInt(0);
        this.intMin = Math.min(this.intMin, v);
        this.intMax = Math.max(this.intMax, v);
    }

    private void transformLong(Row row, PointCollector pc) throws Exception {
        long v = row.getLong(0);
        this.longMin = Math.min(this.longMin, v);
        this.longMax = Math.max(this.longMax, v);
    }

    private void transformFloat(Row row, PointCollector pc) throws Exception {
        float v = row.getFloat(0);
        if (Float.isFinite(v)) {
            this.floatMin = Math.min(this.floatMin, v);
            this.floatMax = Math.max(this.floatMax, v);
        }
    }

    private void transformDouble(Row row, PointCollector pc) throws Exception {
        double v = row.getDouble(0);
        if (Double.isFinite(v)) {
            this.doubleMin = this.doubleMin < v ? this.doubleMin : v;
            this.doubleMax = this.doubleMax > v ? this.doubleMax : v;
        }
    }
}

