/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import org.apache.iotdb.library.dprofile.util.HeapLongKLLSketch;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDAFQuantile
implements UDTF {
    private HeapLongKLLSketch sketch;
    private double rank;
    private Type dataType;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE).validate(K2 -> (Integer)K2 >= 100, "Size K has to be greater or equal than 100.", (Object)validator.getParameters().getIntOrDefault("K", 800)).validate(rank -> (Double)rank > 0.0 && (Double)rank <= 1.0, "rank has to be greater than 0 and less than or equal to 1.", (Object)validator.getParameters().getDoubleOrDefault("rank", 0.5));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(parameters.getDataType(0));
        this.dataType = parameters.getDataType(0);
        int K2 = parameters.getIntOrDefault("K", 800);
        this.rank = parameters.getDoubleOrDefault("rank", 0.5);
        this.sketch = new HeapLongKLLSketch(K2 * 8);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        double res = Util.getValueAsDouble(row);
        this.sketch.update(this.dataToLong(res));
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        long result = this.sketch.findMinValueWithRank((long)(this.rank * (double)this.sketch.getN()));
        double res = this.longToResult(result);
        switch (this.dataType) {
            case INT32: {
                collector.putInt(0L, (int)res);
                break;
            }
            case INT64: {
                collector.putLong(0L, (long)res);
                break;
            }
            case FLOAT: {
                collector.putFloat(0L, (float)res);
                break;
            }
            case DOUBLE: {
                collector.putDouble(0L, res);
            }
        }
    }

    private long dataToLong(Object data) {
        switch (this.dataType) {
            case INT32: {
                return ((Integer)data).intValue();
            }
            case FLOAT: {
                long result = Float.floatToIntBits(((Float)data).floatValue());
                return ((Float)data).floatValue() >= 0.0f ? result : result ^ Long.MAX_VALUE;
            }
            case INT64: {
                return (Long)data;
            }
            case DOUBLE: {
                long result = Double.doubleToLongBits((Double)data);
                return (Double)data >= 0.0 ? result : result ^ Long.MAX_VALUE;
            }
        }
        return (Long)data;
    }

    private double longToResult(long result) {
        switch (this.dataType) {
            case INT32: {
                return result;
            }
            case FLOAT: {
                result = result >>> 31 == 0L ? result : result ^ Long.MAX_VALUE;
                return Float.intBitsToFloat((int)result);
            }
            case INT64: {
                return result;
            }
            case DOUBLE: {
                result = result >>> 63 == 0L ? result : result ^ Long.MAX_VALUE;
                return Double.longBitsToDouble(result);
            }
        }
        return result;
    }
}

