/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dlearn;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFAR
implements UDTF {
    private int p;
    private long interval;
    private List<Long> timeWindow = new ArrayList<Long>();
    private List<Double> valueWindow = new ArrayList<Double>();

    @Override
    public void beforeStart(UDFParameters udfParameters, UDTFConfigurations udtfConfigurations) throws Exception {
        udtfConfigurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(udfParameters.getDataType(0));
        this.p = udfParameters.getIntOrDefault("p", 1);
        udtfConfigurations.setAccessStrategy(new RowByRowAccessStrategy());
        udtfConfigurations.setOutputDataType(Type.DOUBLE);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        if (!row.isNull(0)) {
            this.timeWindow.add(row.getTime());
            this.valueWindow.add(Util.getValueAsDouble(row));
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        int i;
        int length = this.timeWindow.size();
        if (length <= this.p) {
            throw new UDFException("Illegal input.");
        }
        int count = 0;
        long maxFreqInterval = this.timeWindow.get(1) - this.timeWindow.get(0);
        for (int i2 = 2; i2 < this.timeWindow.size(); ++i2) {
            if (maxFreqInterval == this.timeWindow.get(i2) - this.timeWindow.get(i2 - 1)) {
                ++count;
                continue;
            }
            if (--count != 0) continue;
            maxFreqInterval = this.timeWindow.get(i2) - this.timeWindow.get(i2 - 1);
            ++count;
        }
        this.interval = maxFreqInterval;
        ArrayList<Long> imputedTimeWindow = new ArrayList<Long>();
        ArrayList<Double> imputedValueWindow = new ArrayList<Double>();
        imputedTimeWindow.add(this.timeWindow.get(0));
        imputedValueWindow.add(this.valueWindow.get(0));
        for (int i3 = 1; i3 < this.timeWindow.size(); ++i3) {
            if (this.timeWindow.get(i3) - this.timeWindow.get(i3 - 1) > this.interval) {
                int gap = (int)((this.timeWindow.get(i3) - this.timeWindow.get(i3 - 1)) / this.interval);
                double step = (this.valueWindow.get(i3) - this.valueWindow.get(i3 - 1)) / (double)gap;
                for (int j = 1; j < gap; ++j) {
                    imputedTimeWindow.add(this.timeWindow.get(i3 - 1) + (long)j * this.interval);
                    imputedValueWindow.add(this.valueWindow.get(i3 - 1) + (double)j * step);
                }
            }
            imputedTimeWindow.add(this.timeWindow.get(i3));
            imputedValueWindow.add(this.valueWindow.get(i3));
        }
        int newLength = imputedTimeWindow.size();
        double[] resultCovariances = new double[this.p + 1];
        for (int i4 = 0; i4 <= this.p; ++i4) {
            resultCovariances[i4] = 0.0;
            for (int j = 0; j < newLength - i4; ++j) {
                if (j + i4 >= newLength) continue;
                int n = i4;
                resultCovariances[n] = resultCovariances[n] + (Double)imputedValueWindow.get(j) * (Double)imputedValueWindow.get(j + i4);
            }
            int n = i4;
            resultCovariances[n] = resultCovariances[n] / (double)(newLength - i4);
        }
        double[] epsilons = new double[this.p + 1];
        double[] kappas = new double[this.p + 1];
        double[][] alphas = new double[this.p + 1][this.p + 1];
        epsilons[0] = resultCovariances[0];
        for (i = 1; i <= this.p; ++i) {
            int j;
            double tmpSum = 0.0;
            for (j = 1; j <= i - 1; ++j) {
                tmpSum += alphas[j][i - 1] * resultCovariances[i - j];
            }
            kappas[i] = (resultCovariances[i] - tmpSum) / epsilons[i - 1];
            alphas[i][i] = kappas[i];
            if (i > 1) {
                for (j = 1; j <= i - 1; ++j) {
                    alphas[j][i] = alphas[j][i - 1] - kappas[i] * alphas[i - j][i - 1];
                }
            }
            epsilons[i] = (1.0 - kappas[i] * kappas[i]) * epsilons[i - 1];
        }
        for (i = 1; i <= this.p; ++i) {
            collector.putDouble(i, alphas[i][this.p]);
        }
    }
}

