/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.anomaly;

import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFRange
implements UDTF {
    private Type dataType;
    private double upperBound;
    private double lowerBound;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(parameters.getDataType(0));
        this.lowerBound = parameters.getDouble("lower_bound");
        this.upperBound = parameters.getDouble("upper_bound");
        this.dataType = parameters.getDataType(0);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        long timestamp = row.getTime();
        switch (this.dataType) {
            case INT32: {
                int intValue = row.getInt(0);
                if (!((double)intValue > this.upperBound) && !((double)intValue < this.lowerBound)) break;
                Util.putValue(collector, this.dataType, timestamp, intValue);
                break;
            }
            case INT64: {
                long longValue = row.getLong(0);
                if (!((double)longValue > this.upperBound) && !((double)longValue < this.lowerBound)) break;
                Util.putValue(collector, this.dataType, timestamp, longValue);
                break;
            }
            case FLOAT: {
                float floatValue = row.getFloat(0);
                if (!((double)floatValue > this.upperBound) && !((double)floatValue < this.lowerBound)) break;
                Util.putValue(collector, this.dataType, timestamp, Float.valueOf(floatValue));
                break;
            }
            case DOUBLE: {
                double doubleValue = row.getDouble(0);
                if (!(doubleValue > this.upperBound) && !(doubleValue < this.lowerBound)) break;
                Util.putValue(collector, this.dataType, timestamp, doubleValue);
                break;
            }
            default: {
                throw new Exception("No such kind of data type.");
            }
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
    }
}

