/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.BitSet;
import java.util.function.IntConsumer;

public class LexicalScope {
    protected static final int LONGBITS = 64;
    protected long symbols = 0L;
    protected BitSet moreSymbols = null;

    public LexicalScope() {
    }

    protected LexicalScope(long s2, BitSet ms) {
        this.symbols = s2;
        this.moreSymbols = ms != null ? (BitSet)ms.clone() : null;
    }

    protected final BitSet moreSymbols() {
        if (this.moreSymbols == null) {
            this.moreSymbols = new BitSet();
        }
        return this.moreSymbols;
    }

    public boolean hasSymbol(int symbol) {
        if (symbol < 64) {
            return (this.symbols & 1L << symbol) != 0L;
        }
        return this.moreSymbols != null && this.moreSymbols.get(symbol - 64);
    }

    public boolean addSymbol(int symbol) {
        if (symbol < 64) {
            if ((this.symbols & 1L << symbol) != 0L) {
                return false;
            }
            this.symbols |= 1L << symbol;
        } else {
            int s2 = symbol - 64;
            BitSet ms = this.moreSymbols();
            if (ms.get(s2)) {
                return false;
            }
            ms.set(s2, true);
        }
        return true;
    }

    public final void clearSymbols(IntConsumer cleanSymbol) {
        if (cleanSymbol != null) {
            int s2;
            for (long clean = this.symbols; clean != 0L; clean &= 1L << s2 ^ 0xFFFFFFFFFFFFFFFFL) {
                s2 = Long.numberOfTrailingZeros(clean);
                cleanSymbol.accept(s2);
            }
        }
        this.symbols = 0L;
        if (this.moreSymbols != null) {
            if (cleanSymbol != null) {
                int s3 = this.moreSymbols.nextSetBit(0);
                while (s3 != -1) {
                    cleanSymbol.accept(s3 + 64);
                    s3 = this.moreSymbols.nextSetBit(s3 + 1);
                }
            }
            this.moreSymbols.clear();
        }
    }

    public int getSymbolCount() {
        return Long.bitCount(this.symbols) + (this.moreSymbols == null ? 0 : this.moreSymbols.cardinality());
    }
}

