/*
 * Decompiled with CFR 0.152.
 */
package com.github.ggalmazor.ltdownsampling;

import com.github.ggalmazor.ltdownsampling.Bucket;
import com.github.ggalmazor.ltdownsampling.Point;
import java.util.ArrayList;
import java.util.List;

class OnePassBucketizer {
    OnePassBucketizer() {
    }

    static <T extends Point> List<Bucket<T>> bucketize(List<T> input, int inputSize, int desiredBuckets) {
        int middleSize = inputSize - 2;
        int bucketSize = middleSize / desiredBuckets;
        int lastBucketSize = middleSize % desiredBuckets;
        if (bucketSize == 0) {
            throw new IllegalArgumentException("Can't produce " + desiredBuckets + " buckets from an input series of " + (middleSize + 2) + " elements");
        }
        ArrayList<Bucket<T>> buckets = new ArrayList<Bucket<T>>();
        buckets.add(Bucket.of((Point)input.get(0)));
        List<T> rest = input.subList(1, input.size() - 1);
        while (buckets.size() < desiredBuckets + 1) {
            int size = buckets.size() == desiredBuckets ? bucketSize + lastBucketSize : bucketSize;
            buckets.add(Bucket.of(rest.subList(0, size)));
            rest = rest.subList(size, rest.size());
        }
        buckets.add(Bucket.of((Point)input.get(input.size() - 1)));
        return buckets;
    }
}

