/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.task.meta;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeRuntimeMeta {
    private final AtomicReference<PipeStatus> status = new AtomicReference<PipeStatus>(PipeStatus.STOPPED);
    private final Map<TConsensusGroupId, PipeTaskMeta> consensusGroupIdToTaskMetaMap;

    public PipeRuntimeMeta() {
        this.consensusGroupIdToTaskMetaMap = new ConcurrentHashMap<TConsensusGroupId, PipeTaskMeta>();
    }

    public PipeRuntimeMeta(Map<TConsensusGroupId, PipeTaskMeta> consensusGroupIdToTaskMetaMap) {
        this.consensusGroupIdToTaskMetaMap = consensusGroupIdToTaskMetaMap;
    }

    public AtomicReference<PipeStatus> getStatus() {
        return this.status;
    }

    public Map<TConsensusGroupId, PipeTaskMeta> getConsensusGroupIdToTaskMetaMap() {
        return this.consensusGroupIdToTaskMetaMap;
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(DataOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)this.status.get().getType(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.consensusGroupIdToTaskMetaMap.size(), (OutputStream)outputStream);
        for (Map.Entry<TConsensusGroupId, PipeTaskMeta> entry : this.consensusGroupIdToTaskMetaMap.entrySet()) {
            ReadWriteIOUtils.write((int)entry.getKey().getId(), (OutputStream)outputStream);
            entry.getValue().serialize(outputStream);
        }
    }

    public void serialize(FileOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)this.status.get().getType(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.consensusGroupIdToTaskMetaMap.size(), (OutputStream)outputStream);
        for (Map.Entry<TConsensusGroupId, PipeTaskMeta> entry : this.consensusGroupIdToTaskMetaMap.entrySet()) {
            ReadWriteIOUtils.write((int)entry.getKey().getId(), (OutputStream)outputStream);
            entry.getValue().serialize(outputStream);
        }
    }

    public static PipeRuntimeMeta deserialize(InputStream inputStream) throws IOException {
        PipeRuntimeMeta pipeRuntimeMeta = new PipeRuntimeMeta();
        pipeRuntimeMeta.status.set(PipeStatus.getPipeStatus(ReadWriteIOUtils.readByte((InputStream)inputStream)));
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < size; ++i) {
            pipeRuntimeMeta.consensusGroupIdToTaskMetaMap.put(new TConsensusGroupId(TConsensusGroupType.DataRegion, ReadWriteIOUtils.readInt((InputStream)inputStream)), PipeTaskMeta.deserialize(inputStream));
        }
        return pipeRuntimeMeta;
    }

    public static PipeRuntimeMeta deserialize(ByteBuffer byteBuffer) {
        PipeRuntimeMeta pipeRuntimeMeta = new PipeRuntimeMeta();
        pipeRuntimeMeta.status.set(PipeStatus.getPipeStatus(ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer)));
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            pipeRuntimeMeta.consensusGroupIdToTaskMetaMap.put(new TConsensusGroupId(TConsensusGroupType.DataRegion, ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)), PipeTaskMeta.deserialize(byteBuffer));
        }
        return pipeRuntimeMeta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeRuntimeMeta that = (PipeRuntimeMeta)o;
        return Objects.equals(this.status.get().getType(), that.status.get().getType()) && this.consensusGroupIdToTaskMetaMap.equals(that.consensusGroupIdToTaskMetaMap);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.consensusGroupIdToTaskMetaMap);
    }

    public String toString() {
        return "PipeRuntimeMeta{status=" + this.status + ", consensusGroupIdToTaskMetaMap=" + this.consensusGroupIdToTaskMetaMap + '}';
    }
}

