/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;

public class SortBufferManager {
    public static final long SORT_BUFFER_SIZE = IoTDBDescriptor.getInstance().getConfig().getSortBufferSize();
    private long bufferUsed;
    private final long BUFFER_SIZE_FOR_ONE_BRANCH = TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    private final long BUFFER_AVAILABLE_FOR_ALL_BRANCH = SORT_BUFFER_SIZE - (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    private long readerBuffer = 0L;
    private long branchNum = 0L;

    public SortBufferManager() {
        this.bufferUsed = TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    public void allocateOneSortBranch() {
        boolean success = this.allocate(this.BUFFER_SIZE_FOR_ONE_BRANCH);
        if (!success) {
            throw new IllegalArgumentException("Not enough memory for sorting");
        }
        ++this.branchNum;
    }

    private boolean check(long size) {
        return this.bufferUsed + size < SORT_BUFFER_SIZE;
    }

    public boolean allocate(long size) {
        if (this.check(size)) {
            this.bufferUsed += size;
            return true;
        }
        return false;
    }

    public void releaseOneSortBranch() {
        --this.branchNum;
        if (this.branchNum != 0L) {
            this.readerBuffer = this.BUFFER_AVAILABLE_FOR_ALL_BRANCH / this.branchNum;
        }
    }

    public long getReaderBufferAvailable() {
        if (this.readerBuffer != 0L) {
            return this.readerBuffer;
        }
        this.readerBuffer = this.BUFFER_AVAILABLE_FOR_ALL_BRANCH / this.branchNum;
        return this.readerBuffer;
    }
}

