/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.utils.FileUtils;

public class PipeFileResourceManager {
    private final Map<String, Integer> hardlinkOrCopiedFileToReferenceMap = new HashMap<String, Integer>();

    public synchronized File increaseFileReference(File file, boolean isTsFile) throws IOException {
        if (this.increaseReferenceIfExists(file.getPath())) {
            return file;
        }
        File hardlinkOrCopiedFile = PipeFileResourceManager.getHardlinkOrCopiedFileInPipeDir(file);
        if (this.increaseReferenceIfExists(hardlinkOrCopiedFile.getPath())) {
            return hardlinkOrCopiedFile;
        }
        this.hardlinkOrCopiedFileToReferenceMap.put(hardlinkOrCopiedFile.getPath(), 1);
        return isTsFile ? PipeFileResourceManager.createHardLink(file, hardlinkOrCopiedFile) : PipeFileResourceManager.copyFile(file, hardlinkOrCopiedFile);
    }

    private boolean increaseReferenceIfExists(String path) {
        this.hardlinkOrCopiedFileToReferenceMap.computeIfPresent(path, (key, value) -> value + 1);
        return this.hardlinkOrCopiedFileToReferenceMap.containsKey(path);
    }

    private static File getHardlinkOrCopiedFileInPipeDir(File file) throws IOException {
        try {
            return new File(PipeFileResourceManager.getPipeTsFileDirPath(file), PipeFileResourceManager.getRelativeFilePath(file));
        }
        catch (Exception e) {
            throw new IOException(String.format("failed to get hardlink or copied file in pipe dir for file %s, it is not a tsfile, mod file or resource file", file.getPath()), e);
        }
    }

    private static String getPipeTsFileDirPath(File file) throws IOException {
        while (!(file.getName().equals("sequence") || file.getName().equals("unsequence") || file.getName().equals(PipeConfig.getInstance().getPipeHardlinkTsFileDirName()))) {
            file = file.getParentFile();
        }
        return file.getParentFile().getCanonicalPath() + File.separator + PipeConfig.getInstance().getPipeHardlinkTsFileDirName();
    }

    private static String getRelativeFilePath(File file) {
        StringBuilder builder = new StringBuilder(file.getName());
        while (!(file.getName().equals("sequence") || file.getName().equals("unsequence") || file.getName().equals(PipeConfig.getInstance().getPipeHardlinkTsFileDirName()))) {
            file = file.getParentFile();
            builder = new StringBuilder(file.getName()).append("-").append((CharSequence)builder);
        }
        return builder.toString();
    }

    private static File createHardLink(File sourceFile, File hardlink) throws IOException {
        if (!hardlink.getParentFile().exists() && !hardlink.getParentFile().mkdirs()) {
            throw new IOException(String.format("failed to create hardlink %s for file %s: failed to create parent dir %s", hardlink.getPath(), sourceFile.getPath(), hardlink.getParentFile().getPath()));
        }
        Path sourcePath = FileSystems.getDefault().getPath(sourceFile.getAbsolutePath(), new String[0]);
        Path linkPath = FileSystems.getDefault().getPath(hardlink.getAbsolutePath(), new String[0]);
        Files.createLink(linkPath, sourcePath);
        return hardlink;
    }

    private static File copyFile(File sourceFile, File targetFile) throws IOException {
        if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
            throw new IOException(String.format("failed to copy file %s to %s: failed to create parent dir %s", sourceFile.getPath(), targetFile.getPath(), targetFile.getParentFile().getPath()));
        }
        Files.copy(sourceFile.toPath(), targetFile.toPath(), new CopyOption[0]);
        return targetFile;
    }

    public synchronized void decreaseFileReference(File hardlinkOrCopiedFile) throws IOException {
        Integer updatedReference = this.hardlinkOrCopiedFileToReferenceMap.computeIfPresent(hardlinkOrCopiedFile.getPath(), (file, reference) -> reference - 1);
        if (updatedReference != null && updatedReference == 0) {
            Files.deleteIfExists(hardlinkOrCopiedFile.toPath());
            this.hardlinkOrCopiedFileToReferenceMap.remove(hardlinkOrCopiedFile.getPath());
        }
    }

    public synchronized void clear(String dataDir) {
        File pipeTsFileDir = new File(dataDir, PipeConfig.getInstance().getPipeHardlinkTsFileDirName());
        if (pipeTsFileDir.exists()) {
            FileUtils.deleteDirectory((File)pipeTsFileDir);
        }
    }

    public synchronized int getFileReferenceCount(File hardlinkOrCopiedFile) {
        return this.hardlinkOrCopiedFileToReferenceMap.getOrDefault(hardlinkOrCopiedFile.getPath(), 0);
    }
}

