/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.realtime;

import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.listener.PipeInsertionDataNodeListener;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;

public abstract class PipeRealtimeDataRegionExtractor
implements PipeExtractor {
    protected String pattern;
    protected String dataRegionId;
    protected PipeTaskMeta pipeTaskMeta;

    protected PipeRealtimeDataRegionExtractor() {
    }

    public void validate(PipeParameterValidator validator) throws Exception {
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        this.pattern = parameters.getStringOrDefault("extractor.pattern", "root");
        PipeTaskExtractorRuntimeEnvironment environment = (PipeTaskExtractorRuntimeEnvironment)configuration.getRuntimeEnvironment();
        this.dataRegionId = String.valueOf(environment.getRegionId());
        this.pipeTaskMeta = environment.getPipeTaskMeta();
    }

    public void start() throws Exception {
        PipeInsertionDataNodeListener.getInstance().startListenAndAssign(this.dataRegionId, this);
    }

    public void close() throws Exception {
        PipeInsertionDataNodeListener.getInstance().stopListenAndAssign(this.dataRegionId, this);
    }

    public abstract void extract(PipeRealtimeEvent var1);

    public abstract boolean isNeedListenToTsFile();

    public abstract boolean isNeedListenToInsertNode();

    public final String getPattern() {
        return this.pattern;
    }

    public final PipeTaskMeta getPipeTaskMeta() {
        return this.pipeTaskMeta;
    }

    public String toString() {
        return "PipeRealtimeDataRegionExtractor{pattern='" + this.pattern + '\'' + ", dataRegionId='" + this.dataRegionId + '\'' + '}';
    }
}

