/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.v1;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.connector.v1.IoTDBThriftConnectorClient;
import org.apache.iotdb.db.pipe.connector.v1.reponse.PipeTransferFilePieceResp;
import org.apache.iotdb.db.pipe.connector.v1.request.PipeTransferFilePieceReq;
import org.apache.iotdb.db.pipe.connector.v1.request.PipeTransferFileSealReq;
import org.apache.iotdb.db.pipe.connector.v1.request.PipeTransferHandshakeReq;
import org.apache.iotdb.db.pipe.connector.v1.request.PipeTransferInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.v1.request.PipeTransferTabletReq;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.wal.exception.WALPipeException;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBThriftConnectorV1
implements PipeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBThriftConnectorV1.class);
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private String ipAddress;
    private int port;
    private IoTDBThriftConnectorClient client;

    public void validate(PipeParameterValidator validator) throws Exception {
        validator.validateRequiredAttribute("connector.ip").validateRequiredAttribute("connector.port");
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        this.ipAddress = parameters.getString("connector.ip");
        this.port = parameters.getInt("connector.port");
    }

    public void handshake() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        this.client = new IoTDBThriftConnectorClient(new ThriftClientProperty.Builder().setConnectionTimeoutMs(COMMON_CONFIG.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(COMMON_CONFIG.isRpcThriftCompressionEnabled()).build(), this.ipAddress, this.port);
        try {
            TPipeTransferResp resp = this.client.pipeTransfer(PipeTransferHandshakeReq.toTPipeTransferReq(CommonDescriptor.getInstance().getConfig().getTimestampPrecision()));
            if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new PipeException(String.format("Handshake error, result status %s.", resp.status));
            }
        }
        catch (TException e) {
            throw new PipeConnectionException(String.format("Connect to receiver %s:%s error, because: %s", this.ipAddress, this.port, e.getMessage()), (Throwable)e);
        }
    }

    public void heartbeat() throws Exception {
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        block4: {
            try {
                if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                    this.doTransfer((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent);
                    break block4;
                }
                if (tabletInsertionEvent instanceof PipeRawTabletInsertionEvent) {
                    this.doTransfer((PipeRawTabletInsertionEvent)tabletInsertionEvent);
                    break block4;
                }
                throw new NotImplementedException("IoTDBThriftConnectorV1 only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent.");
            }
            catch (TException e) {
                throw new PipeConnectionException(String.format("Network error when transfer tablet insertion event %s, because %s.", tabletInsertionEvent, e.getMessage()), (Throwable)e);
            }
        }
    }

    private void doTransfer(PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent) throws PipeException, TException, WALPipeException {
        TPipeTransferResp resp = this.client.pipeTransfer(PipeTransferInsertNodeReq.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getInsertNode()));
        if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Transfer PipeInsertNodeTabletInsertionEvent %s error, result status %s", pipeInsertNodeTabletInsertionEvent, resp.status));
        }
    }

    private void doTransfer(PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent) throws PipeException, TException, IOException {
        TPipeTransferResp resp = this.client.pipeTransfer(PipeTransferTabletReq.toTPipeTransferReq(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isAligned()));
        if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Transfer PipeRawTabletInsertionEvent %s error, result status %s", pipeRawTabletInsertionEvent, resp.status));
        }
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            throw new NotImplementedException("IoTDBThriftConnectorV1 only support PipeTsFileInsertionEvent.");
        }
        try {
            this.doTransfer((PipeTsFileInsertionEvent)tsFileInsertionEvent);
        }
        catch (TException e) {
            throw new PipeConnectionException(String.format("Network error when transfer tsfile insertion event %s, because %s.", tsFileInsertionEvent, e.getMessage()), (Throwable)e);
        }
    }

    private void doTransfer(PipeTsFileInsertionEvent pipeTsFileInsertionEvent) throws PipeException, TException, InterruptedException, IOException {
        File tsFile;
        block9: {
            pipeTsFileInsertionEvent.waitForTsFileClose();
            tsFile = pipeTsFileInsertionEvent.getTsFile();
            int readFileBufferSize = PipeConfig.getInstance().getPipeConnectorReadFileBufferSize();
            byte[] readBuffer = new byte[readFileBufferSize];
            long position = 0L;
            try (RandomAccessFile reader = new RandomAccessFile(tsFile, "r");){
                PipeTransferFilePieceResp resp;
                while (true) {
                    int readLength;
                    if ((readLength = reader.read(readBuffer)) == -1) {
                        break block9;
                    }
                    resp = PipeTransferFilePieceResp.fromTPipeTransferResp(this.client.pipeTransfer(PipeTransferFilePieceReq.toTPipeTransferReq(tsFile.getName(), position, readLength == readFileBufferSize ? readBuffer : Arrays.copyOfRange(readBuffer, 0, readLength))));
                    position += (long)readLength;
                    if (resp.getStatus().getCode() == TSStatusCode.PIPE_TRANSFER_FILE_OFFSET_RESET.getStatusCode()) {
                        position = resp.getEndWritingOffset();
                        reader.seek(position);
                        LOGGER.info("Redirect file position to {}.", (Object)position);
                        continue;
                    }
                    if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) break;
                }
                throw new PipeException(String.format("Transfer file %s error, result status %s.", tsFile, resp.getStatus()));
            }
        }
        TPipeTransferResp resp = this.client.pipeTransfer(PipeTransferFileSealReq.toTPipeTransferReq(tsFile.getName(), tsFile.length()));
        if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Seal file %s error, result status %s.", tsFile, resp.getStatus()));
        }
    }

    public void transfer(Event event) {
        LOGGER.warn("IoTDBThriftConnectorV1 does not support transfer generic event: {}.", (Object)event);
    }

    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
    }
}

