/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.mpp.plan.analyze.GroupByLevelController;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ReconstructVisitor;

public class ReplaceRawPathWithGroupedPathVisitor
extends ReconstructVisitor<GroupByLevelController.RawPathToGroupedPathMap> {
    @Override
    public Expression visitFunctionExpression(FunctionExpression functionExpression, GroupByLevelController.RawPathToGroupedPathMap rawPathToGroupedPathMap) {
        ArrayList<Expression> childrenExpressions = new ArrayList<Expression>();
        for (Expression childExpression : functionExpression.getExpressions()) {
            childrenExpressions.add((Expression)this.process(childExpression, rawPathToGroupedPathMap));
            if (!functionExpression.isBuiltInAggregationFunctionExpression()) continue;
            List<Expression> children = functionExpression.getExpressions();
            for (int i = 1; i < children.size(); ++i) {
                childrenExpressions.add(children.get(i));
            }
        }
        return ExpressionUtils.reconstructFunctionExpression(functionExpression, childrenExpressions);
    }

    @Override
    public Expression visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, GroupByLevelController.RawPathToGroupedPathMap rawPathToGroupedPathMap) {
        PartialPath rawPath = timeSeriesOperand.getPath();
        PartialPath groupedPath = rawPathToGroupedPathMap.get(rawPath);
        return ExpressionUtils.reconstructTimeSeriesOperand(timeSeriesOperand, groupedPath);
    }

    @Override
    public Expression visitTimeStampOperand(TimestampOperand timestampOperand, GroupByLevelController.RawPathToGroupedPathMap context) {
        return timestampOperand;
    }

    @Override
    public Expression visitConstantOperand(ConstantOperand constantOperand, GroupByLevelController.RawPathToGroupedPathMap context) {
        return constantOperand;
    }
}

