/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.sys.pipe;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeInfo;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.sys.pipe.ShowPipesStatement;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class ShowPipeTask
implements IConfigTask {
    private final ShowPipesStatement showPipesStatement;

    public ShowPipeTask(ShowPipesStatement showPipesStatement) {
        this.showPipesStatement = showPipesStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showPipes(this.showPipesStatement);
    }

    public static void buildTSBlock(List<TShowPipeInfo> pipeInfoList, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showPipeColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        for (TShowPipeInfo tPipeInfo : pipeInfoList) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(tPipeInfo.getId()));
            builder.getColumnBuilder(1).writeBinary(new Binary(DateTimeUtils.convertLongToDate(tPipeInfo.getCreationTime(), "ms")));
            builder.getColumnBuilder(2).writeBinary(new Binary(tPipeInfo.getState()));
            builder.getColumnBuilder(3).writeBinary(new Binary(tPipeInfo.getPipeExtractor()));
            builder.getColumnBuilder(4).writeBinary(new Binary(tPipeInfo.getPipeProcessor()));
            builder.getColumnBuilder(5).writeBinary(new Binary(tPipeInfo.getPipeConnector()));
            builder.getColumnBuilder(6).writeBinary(new Binary(tPipeInfo.getExceptionMessage()));
            builder.declarePosition();
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowPipeHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

