/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iotdb.db.metadata.query.info.ISchemaInfo;
import org.apache.iotdb.db.metadata.query.reader.ISchemaReader;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class SchemaCountOperator<T extends ISchemaInfo>
implements SourceOperator {
    private static final List<TSDataType> OUTPUT_DATA_TYPES = Collections.singletonList(TSDataType.INT64);
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final ISchemaSource<T> schemaSource;
    private ISchemaReader<T> schemaReader;
    private int count;
    private boolean isFinished;
    private ListenableFuture<?> isBlocked;
    private TsBlock next;

    public SchemaCountOperator(PlanNodeId sourceId, OperatorContext operatorContext, ISchemaSource<T> schemaSource) {
        this.sourceId = sourceId;
        this.operatorContext = operatorContext;
        this.schemaSource = schemaSource;
    }

    private ISchemaRegion getSchemaRegion() {
        return ((SchemaDriverContext)this.operatorContext.getDriverContext()).getSchemaRegion();
    }

    private ISchemaReader<T> createSchemaReader() {
        return this.schemaSource.getSchemaReader(this.getSchemaRegion());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.isBlocked == null) {
            this.isBlocked = this.tryGetNext();
        }
        return this.isBlocked;
    }

    private ListenableFuture<?> tryGetNext() {
        ISchemaRegion schemaRegion = this.getSchemaRegion();
        if (this.schemaSource.hasSchemaStatistic(schemaRegion)) {
            this.next = this.constructTsBlock(this.schemaSource.getSchemaStatistic(schemaRegion));
            return NOT_BLOCKED;
        }
        if (this.schemaReader == null) {
            this.schemaReader = this.createSchemaReader();
        }
        try {
            while (true) {
                ListenableFuture<?> readerBlocked;
                if (!(readerBlocked = this.schemaReader.isBlocked()).isDone()) {
                    return readerBlocked;
                }
                if (!this.schemaReader.hasNext()) break;
                this.schemaReader.next();
                ++this.count;
            }
            this.next = this.constructTsBlock(this.count);
            return NOT_BLOCKED;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.next != null) {
            this.isFinished = true;
        }
        this.isBlocked = null;
        return this.next;
    }

    @Override
    public boolean hasNext() throws Exception {
        this.isBlocked().get();
        if (this.schemaReader != null && !this.schemaReader.isSuccess()) {
            throw new RuntimeException(this.schemaReader.getFailure());
        }
        return !this.isFinished;
    }

    private TsBlock constructTsBlock(long count) {
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(OUTPUT_DATA_TYPES);
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeLong(count);
        tsBlockBuilder.declarePosition();
        return tsBlockBuilder.build();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.isFinished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return 8L;
    }

    @Override
    public long calculateMaxReturnSize() {
        return 8L;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public void close() throws Exception {
        if (this.schemaReader != null) {
            this.schemaReader.close();
            this.schemaReader = null;
        }
    }
}

