/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.schemafile;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.db.metadata.mnode.schemafile.ICachedMNode;
import org.apache.iotdb.db.metadata.mnode.schemafile.container.ICachedMNodeContainer;
import org.apache.iotdb.db.metadata.mnode.utils.MNodeFactoryLoader;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class RecordUtils {
    private static final short INTERNAL_NODE_LENGTH = 16;
    private static final short MEASUREMENT_BASIC_LENGTH = 19;
    private static final short LENGTH_OFFSET = 1;
    private static final short ALIAS_OFFSET = 19;
    private static final short SEG_ADDRESS_OFFSET = 3;
    private static final short SCHEMA_OFFSET = 11;
    private static final short INTERNAL_BITFLAG_OFFSET = 15;
    private static final byte INTERNAL_TYPE = 0;
    private static final byte ENTITY_TYPE = 1;
    private static final byte MEASUREMENT_TYPE = 4;
    private static final IMNodeFactory<ICachedMNode> nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();

    public static ByteBuffer node2Buffer(ICachedMNode node) {
        if (node.isMeasurement()) {
            return RecordUtils.measurement2Buffer((IMeasurementMNode<ICachedMNode>)node.getAsMeasurementMNode());
        }
        return RecordUtils.internal2Buffer(node);
    }

    private static ByteBuffer internal2Buffer(ICachedMNode node) {
        byte nodeType = 0;
        boolean isAligned = false;
        int schemaTemplateIdWithState = -1;
        boolean isUseTemplate = false;
        if (node.isDevice()) {
            nodeType = 1;
            isAligned = node.getAsDeviceMNode().isAligned();
            schemaTemplateIdWithState = node.getAsDeviceMNode().getSchemaTemplateIdWithState();
            isUseTemplate = node.getAsDeviceMNode().isUseTemplate();
        }
        ByteBuffer buffer = ByteBuffer.allocate(16);
        ReadWriteIOUtils.write((byte)nodeType, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((short)16, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((long)ICachedMNodeContainer.getCachedMNodeContainer(node).getSegmentAddress(), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)schemaTemplateIdWithState, (ByteBuffer)buffer);
        byte useAndAligned = RecordUtils.encodeInternalStatus(isUseTemplate, isAligned);
        ReadWriteIOUtils.write((byte)useAndAligned, (ByteBuffer)buffer);
        return buffer;
    }

    private static ByteBuffer measurement2Buffer(IMeasurementMNode<ICachedMNode> node) {
        int bufferLength = node.getAlias() == null ? 23 : node.getAlias().getBytes().length + 4 + 19;
        bufferLength += 4;
        if (node.getSchema().getProps() != null) {
            for (Map.Entry e : node.getSchema().getProps().entrySet()) {
                bufferLength += 8 + ((String)e.getKey()).getBytes().length + ((String)e.getValue()).length();
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(bufferLength);
        ReadWriteIOUtils.write((byte)4, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((short)((short)bufferLength), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((long)RecordUtils.convertTags2Long(node), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((long)RecordUtils.convertMeasStat2Long(node), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((String)node.getAlias(), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((Map)node.getSchema().getProps(), (ByteBuffer)buffer);
        return buffer;
    }

    public static ICachedMNode buffer2Node(String nodeName, ByteBuffer buffer) throws MetadataException {
        byte nodeType = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
        if (nodeType < 2) {
            ICachedMNode resNode;
            short recLen = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            long segAddr = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
            int templateId = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            byte bitFlag = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
            boolean usingTemplate = RecordUtils.usingTemplate(bitFlag);
            boolean isAligned = RecordUtils.isAligned(bitFlag);
            if (nodeType == 0) {
                resNode = (ICachedMNode)nodeFactory.createInternalMNode(null, nodeName);
            } else {
                resNode = (ICachedMNode)nodeFactory.createDeviceMNode(null, nodeName).getAsMNode();
                resNode.getAsDeviceMNode().setAligned(Boolean.valueOf(isAligned));
                resNode.getAsDeviceMNode().setUseTemplate(usingTemplate);
                resNode.getAsDeviceMNode().setSchemaTemplateId(templateId);
            }
            ICachedMNodeContainer.getCachedMNodeContainer(resNode).setSegmentAddress(segAddr);
            return resNode;
        }
        short recLenth = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
        long tagIndex = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        long schemaByte = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        String alias = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        Map props = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        return RecordUtils.paddingMeasurement(nodeName, tagIndex, schemaByte, alias, props);
    }

    public static short getRecordLength(ByteBuffer recBuf) {
        int oriPos = recBuf.position();
        recBuf.position(oriPos + 1);
        short len = ReadWriteIOUtils.readShort((ByteBuffer)recBuf);
        recBuf.position(oriPos);
        return len;
    }

    public static byte getRecordType(ByteBuffer recBuf) {
        int oriPos = recBuf.position();
        recBuf.position(oriPos);
        byte type = ReadWriteIOUtils.readByte((ByteBuffer)recBuf);
        recBuf.position(oriPos);
        return type;
    }

    public static long getRecordSegAddr(ByteBuffer recBuf) {
        int oriPos = recBuf.position();
        recBuf.position(oriPos + 3);
        long addr = ReadWriteIOUtils.readLong((ByteBuffer)recBuf);
        recBuf.position(oriPos);
        return addr;
    }

    public static byte[] getMeasStatsBytes(ByteBuffer recBuf) {
        byte[] res = new byte[4];
        int oriPos = recBuf.position();
        recBuf.position(oriPos + 11);
        long statusBytes = ReadWriteIOUtils.readLong((ByteBuffer)recBuf);
        res[0] = (byte)(statusBytes >>> 16 & 0xFFL);
        res[1] = (byte)(statusBytes >>> 8 & 0xFFL);
        res[2] = (byte)(statusBytes & 0xFFL);
        res[3] = (byte)(statusBytes >>> 24 & 0xFFL);
        recBuf.position(oriPos);
        return res;
    }

    public static boolean getAlignment(ByteBuffer recBuf) {
        int oriPos = recBuf.position();
        recBuf.position(oriPos + 15);
        byte flag = ReadWriteIOUtils.readByte((ByteBuffer)recBuf);
        recBuf.position(oriPos);
        return RecordUtils.isAligned(flag);
    }

    public static String getRecordAlias(ByteBuffer recBuf) {
        int oriPos = recBuf.position();
        if (ReadWriteIOUtils.readByte((ByteBuffer)recBuf) != 4) {
            recBuf.position(oriPos);
            return null;
        }
        recBuf.position(oriPos + 19);
        String alias = ReadWriteIOUtils.readString((ByteBuffer)recBuf);
        recBuf.position(oriPos);
        return alias;
    }

    public static void updateSegAddr(ByteBuffer recBuf, long newSegAddr) {
        int oriPos = recBuf.position();
        recBuf.position(oriPos + 3);
        ReadWriteIOUtils.write((long)newSegAddr, (ByteBuffer)recBuf);
        recBuf.position(oriPos);
    }

    public static String buffer2String(ByteBuffer buffer) throws MetadataException {
        StringBuilder builder = new StringBuilder("[");
        ICachedMNode node = RecordUtils.buffer2Node("unspecified", buffer);
        if (node.isMeasurement()) {
            builder.append("measurementNode, ");
            builder.append(String.format("alias: %s, ", node.getAsMeasurementMNode().getAlias() == null ? "" : node.getAsMeasurementMNode().getAlias()));
            builder.append(String.format("type: %s, ", node.getAsMeasurementMNode().getDataType().toString()));
            builder.append(String.format("encoding: %s, ", node.getAsMeasurementMNode().getSchema().getEncodingType().toString()));
            builder.append(String.format("compressor: %s]", node.getAsMeasurementMNode().getSchema().getCompressor().toString()));
            return builder.toString();
        }
        if (node.isDevice()) {
            builder.append("entityNode, ");
            if (node.getAsDeviceMNode().isAligned()) {
                builder.append("aligned, ");
            } else {
                builder.append("not aligned, ");
            }
            if (node.getAsDeviceMNode().isUseTemplate()) {
                builder.append("using template.]");
            } else {
                builder.append("not using template.]");
            }
        } else {
            builder.append("internalNode, ");
        }
        return builder.toString();
    }

    private static long convertTags2Long(IMeasurementMNode<ICachedMNode> node) {
        return node.getOffset();
    }

    private static long convertMeasStat2Long(IMeasurementMNode<ICachedMNode> node) {
        byte dataType = node.getSchema().getTypeInByte();
        byte encoding = node.getSchema().getEncodingType().serialize();
        byte compressor = node.getSchema().getCompressor().serialize();
        byte preDelete = (byte)(node.getAsMeasurementMNode().isPreDeleted() ? 1 : 0);
        return preDelete << 24 | dataType << 16 | encoding << 8 | compressor;
    }

    private static ICachedMNode paddingMeasurement(String nodeName, long tagIndex, long statsBytes, String alias, Map<String, String> props) {
        byte preDel = (byte)(statsBytes >>> 24);
        byte dataType = (byte)(statsBytes >>> 16);
        byte encoding = (byte)(statsBytes >>> 8 & 0xFFL);
        byte compressor = (byte)(statsBytes & 0xFFL);
        MeasurementSchema schema = new MeasurementSchema(nodeName, TSDataType.values()[dataType], TSEncoding.values()[encoding], CompressionType.deserialize((byte)compressor), props);
        ICachedMNode res = (ICachedMNode)nodeFactory.createMeasurementMNode(null, nodeName, (IMeasurementSchema)schema, alias).getAsMNode();
        res.getAsMeasurementMNode().setOffset(tagIndex);
        if (preDel > 0) {
            res.getAsMeasurementMNode().setPreDeleted(true);
        }
        return res;
    }

    private static byte encodeInternalStatus(boolean usingTemplate, boolean isAligned) {
        byte flag = 0;
        if (usingTemplate) {
            flag = (byte)(flag | 1);
        }
        if (isAligned) {
            flag = (byte)(flag | 2);
        }
        return flag;
    }

    private static boolean isAligned(byte flag) {
        return (flag & 2) == 2;
    }

    private static boolean usingTemplate(byte flag) {
        return (flag & 1) == 1;
    }
}

