/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.selector.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.selector.ICompactionSelector;
import org.apache.iotdb.db.engine.compaction.selector.ICrossSpaceSelector;
import org.apache.iotdb.db.engine.compaction.selector.estimator.AbstractCompactionEstimator;
import org.apache.iotdb.db.engine.compaction.selector.utils.CrossCompactionTaskResource;
import org.apache.iotdb.db.engine.compaction.selector.utils.CrossSpaceCompactionCandidate;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteCrossSpaceCompactionSelector
implements ICrossSpaceSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected String logicalStorageGroupName;
    protected String dataRegionId;
    protected long timePartition;
    protected TsFileManager tsFileManager;
    private static boolean hasPrintedLog = false;
    private final long memoryBudget;
    private final int maxCrossCompactionFileNum;
    private final long maxCrossCompactionFileSize;
    private AbstractCompactionEstimator compactionEstimator;

    public RewriteCrossSpaceCompactionSelector(String logicalStorageGroupName, String dataRegionId, long timePartition, TsFileManager tsFileManager) {
        this.logicalStorageGroupName = logicalStorageGroupName;
        this.dataRegionId = dataRegionId;
        this.timePartition = timePartition;
        this.tsFileManager = tsFileManager;
        this.memoryBudget = (long)((double)SystemInfo.getInstance().getMemorySizeForCompaction() / (double)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * config.getUsableCompactionMemoryProportion());
        this.maxCrossCompactionFileNum = IoTDBDescriptor.getInstance().getConfig().getFileLimitPerCrossTask();
        this.maxCrossCompactionFileSize = IoTDBDescriptor.getInstance().getConfig().getMaxCrossCompactionCandidateFileSize();
        this.compactionEstimator = ICompactionSelector.getCompactionEstimator(IoTDBDescriptor.getInstance().getConfig().getCrossCompactionPerformer(), false);
    }

    public CrossCompactionTaskResource selectOneTaskResources(CrossSpaceCompactionCandidate candidate) throws MergeException {
        try {
            CrossCompactionTaskResource taskResource;
            LOGGER.debug("Selecting cross compaction task resources from {} seqFile, {} unseqFiles", (Object)candidate.getSeqFiles().size(), (Object)candidate.getUnseqFiles().size());
            CrossCompactionTaskResource crossCompactionTaskResource = taskResource = this.executeTaskResourceSelection(candidate);
            return crossCompactionTaskResource;
        }
        catch (IOException e) {
            throw new MergeException(e);
        }
        finally {
            try {
                this.compactionEstimator.close();
            }
            catch (IOException e) {
                throw new MergeException(e);
            }
        }
    }

    private boolean isAllFileCandidateValid(List<CrossSpaceCompactionCandidate.TsFileResourceCandidate> tsFileResourceCandidates) {
        for (CrossSpaceCompactionCandidate.TsFileResourceCandidate candidate : tsFileResourceCandidates) {
            if (candidate.isValidCandidate) continue;
            return false;
        }
        return true;
    }

    private CrossCompactionTaskResource executeTaskResourceSelection(CrossSpaceCompactionCandidate candidate) throws IOException {
        CrossCompactionTaskResource taskResource = new CrossCompactionTaskResource();
        while (candidate.hasNextSplit()) {
            long memoryCost;
            CrossSpaceCompactionCandidate.CrossCompactionTaskResourceSplit split = candidate.nextSplit();
            TsFileResource unseqFile = split.unseqFile.resource;
            List<TsFileResource> targetSeqFiles = split.seqFiles.stream().map(c -> c.resource).collect(Collectors.toList());
            if (!split.hasOverlap) {
                LOGGER.debug("Unseq file {} does not overlap with any seq files.", (Object)unseqFile);
                CrossSpaceCompactionCandidate.TsFileResourceCandidate latestSealedSeqFile = this.getLatestSealedSeqFile(candidate.getSeqFileCandidates());
                if (latestSealedSeqFile == null) break;
                if (!latestSealedSeqFile.selected) {
                    targetSeqFiles.add(latestSealedSeqFile.resource);
                    latestSealedSeqFile.markAsSelected();
                }
            }
            if (!this.canAddToTaskResource(taskResource, unseqFile, targetSeqFiles, memoryCost = this.compactionEstimator.estimateCrossCompactionMemory(targetSeqFiles, unseqFile))) break;
            taskResource.putResources(unseqFile, targetSeqFiles, memoryCost);
            LOGGER.debug("Adding a new unseqFile {} and seqFiles {} as candidates, new cost {}, total cost {}", new Object[]{unseqFile, targetSeqFiles, memoryCost, taskResource.getTotalMemoryCost()});
        }
        taskResource.sortSeqFiles(candidate.getSeqFiles());
        return taskResource;
    }

    private CrossSpaceCompactionCandidate.TsFileResourceCandidate getLatestSealedSeqFile(List<CrossSpaceCompactionCandidate.TsFileResourceCandidate> seqResourceCandidateList) {
        for (int i = seqResourceCandidateList.size() - 1; i >= 0; --i) {
            CrossSpaceCompactionCandidate.TsFileResourceCandidate seqResourceCandidate = seqResourceCandidateList.get(i);
            if (!seqResourceCandidate.resource.isClosed()) continue;
            if (!seqResourceCandidate.isValidCandidate) break;
            LOGGER.debug("Select one valid seq file {} for nonOverlap unseq file to compact with.", (Object)seqResourceCandidate.resource);
            return seqResourceCandidate;
        }
        return null;
    }

    private boolean canAddToTaskResource(CrossCompactionTaskResource taskResource, TsFileResource unseqFile, List<TsFileResource> seqFiles, long memoryCost) throws IOException {
        if (memoryCost == -1L) {
            return false;
        }
        TsFileNameGenerator.TsFileName unseqFileName = TsFileNameGenerator.getTsFileName(unseqFile.getTsFile().getName());
        if (unseqFile.getTsFileSize() < config.getTargetCompactionFileSize() && unseqFileName.getInnerCompactionCnt() < config.getMinCrossCompactionUnseqFileLevel()) {
            return false;
        }
        long totalFileSize = unseqFile.getTsFileSize();
        for (TsFileResource f : seqFiles) {
            if (f.getTsFileSize() >= config.getTargetCompactionFileSize()) {
                return false;
            }
            totalFileSize += f.getTsFileSize();
        }
        if (taskResource.getUnseqFiles().isEmpty()) {
            return true;
        }
        return taskResource.getTotalFileNums() + 1L + (long)seqFiles.size() <= (long)this.maxCrossCompactionFileNum && taskResource.getTotalFileSize() + totalFileSize <= this.maxCrossCompactionFileSize && taskResource.getTotalMemoryCost() + memoryCost < this.memoryBudget;
    }

    private boolean canSubmitCrossTask(List<TsFileResource> sequenceFileList, List<TsFileResource> unsequenceFileList) {
        return !sequenceFileList.isEmpty() && !unsequenceFileList.isEmpty();
    }

    @Override
    public List<CrossCompactionTaskResource> selectCrossSpaceTask(List<TsFileResource> sequenceFileList, List<TsFileResource> unsequenceFileList) {
        if (!this.canSubmitCrossTask(sequenceFileList, unsequenceFileList)) {
            return Collections.emptyList();
        }
        long startTime = System.currentTimeMillis();
        long ttlLowerBound = System.currentTimeMillis() - Long.MAX_VALUE;
        CrossSpaceCompactionCandidate candidate = new CrossSpaceCompactionCandidate(sequenceFileList, unsequenceFileList, ttlLowerBound);
        try {
            CrossCompactionTaskResource taskResources = this.selectOneTaskResources(candidate);
            if (!taskResources.isValid()) {
                if (!hasPrintedLog) {
                    LOGGER.info("{} [Compaction] Total source files: {} seqFiles, {} unseqFiles. Candidate source files: {} seqFiles, {} unseqFiles. Cannot select any files because they do not meet the conditions or may be occupied by other compaction threads.", new Object[]{this.logicalStorageGroupName + "-" + this.dataRegionId, sequenceFileList.size(), unsequenceFileList.size(), candidate.getSeqFiles().size(), candidate.getUnseqFiles().size()});
                    hasPrintedLog = true;
                }
                return Collections.emptyList();
            }
            LOGGER.info("{} [Compaction] Total source files: {} seqFiles, {} unseqFiles. Candidate source files: {} seqFiles, {} unseqFiles. Selected source files: {} seqFiles, {} unseqFiles, total memory cost {} MB, total selected file size is {} MB, total selected seq file size is {} MB, total selected unseq file size is {} MB, time consumption {}ms.", new Object[]{this.logicalStorageGroupName + "-" + this.dataRegionId, sequenceFileList.size(), unsequenceFileList.size(), candidate.getSeqFiles().size(), candidate.getUnseqFiles().size(), taskResources.getSeqFiles().size(), taskResources.getUnseqFiles().size(), Float.valueOf((float)taskResources.getTotalMemoryCost() / 1024.0f / 1024.0f), Float.valueOf((float)taskResources.getTotalFileSize() / 1024.0f / 1024.0f), Float.valueOf(taskResources.getTotalSeqFileSize() / 1024.0f / 1024.0f), Float.valueOf(taskResources.getTotalUnseqFileSize() / 1024.0f / 1024.0f), System.currentTimeMillis() - startTime});
            hasPrintedLog = false;
            return Collections.singletonList(taskResources);
        }
        catch (MergeException e) {
            LOGGER.error("{} cannot select file for cross space compaction", (Object)this.logicalStorageGroupName, (Object)e);
            return Collections.emptyList();
        }
    }
}

