/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.datastructure.tv;

import org.apache.iotdb.db.mpp.transformation.datastructure.SerializableList;
import org.apache.iotdb.db.mpp.transformation.datastructure.tv.SerializableBinaryTVList;
import org.apache.iotdb.db.mpp.transformation.datastructure.tv.SerializableBooleanTVList;
import org.apache.iotdb.db.mpp.transformation.datastructure.tv.SerializableDoubleTVList;
import org.apache.iotdb.db.mpp.transformation.datastructure.tv.SerializableFloatTVList;
import org.apache.iotdb.db.mpp.transformation.datastructure.tv.SerializableIntTVList;
import org.apache.iotdb.db.mpp.transformation.datastructure.tv.SerializableLongTVList;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;

public abstract class SerializableTVList
extends BatchData
implements SerializableList {
    protected final SerializableList.SerializationRecorder serializationRecorder;

    public static SerializableTVList newSerializableTVList(TSDataType dataType, String queryId) {
        SerializableList.SerializationRecorder recorder = new SerializableList.SerializationRecorder(queryId);
        switch (dataType) {
            case INT32: {
                return new SerializableIntTVList(recorder);
            }
            case INT64: {
                return new SerializableLongTVList(recorder);
            }
            case FLOAT: {
                return new SerializableFloatTVList(recorder);
            }
            case DOUBLE: {
                return new SerializableDoubleTVList(recorder);
            }
            case BOOLEAN: {
                return new SerializableBooleanTVList(recorder);
            }
            case TEXT: {
                return new SerializableBinaryTVList(recorder);
            }
        }
        throw new UnSupportedDataTypeException(dataType.toString());
    }

    protected static int calculateCapacity(TSDataType dataType, float memoryLimitInMB) {
        int size;
        switch (dataType) {
            case INT32: {
                size = SerializableIntTVList.calculateCapacity(memoryLimitInMB);
                break;
            }
            case INT64: {
                size = SerializableLongTVList.calculateCapacity(memoryLimitInMB);
                break;
            }
            case FLOAT: {
                size = SerializableFloatTVList.calculateCapacity(memoryLimitInMB);
                break;
            }
            case DOUBLE: {
                size = SerializableDoubleTVList.calculateCapacity(memoryLimitInMB);
                break;
            }
            case BOOLEAN: {
                size = SerializableBooleanTVList.calculateCapacity(memoryLimitInMB);
                break;
            }
            case TEXT: {
                size = SerializableBinaryTVList.calculateCapacity(memoryLimitInMB, SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(dataType.toString());
            }
        }
        if (size <= 0) {
            throw new RuntimeException("Memory is not enough for current query.");
        }
        return size;
    }

    protected SerializableTVList(TSDataType type, SerializableList.SerializationRecorder serializationRecorder) {
        super(type);
        this.serializationRecorder = serializationRecorder;
    }

    @Override
    public SerializableList.SerializationRecorder getSerializationRecorder() {
        return this.serializationRecorder;
    }

    @Override
    public void init() {
        this.init(this.getDataType());
    }
}

