/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer.multi;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.multi.UDFQueryTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;

public abstract class UniversalUDFQueryTransformer
extends UDFQueryTransformer {
    protected final LayerPointReader layerPointReader;
    protected final boolean isLayerPointReaderConstant;

    protected UniversalUDFQueryTransformer(UDTFExecutor executor) {
        super(executor);
        this.layerPointReader = executor.getCollector().constructPointReaderUsingTrivialEvictionStrategy();
        this.isLayerPointReaderConstant = this.layerPointReader.isConstantPointReader();
    }

    @Override
    protected final YieldableState yieldValue() throws Exception {
        while (!this.cacheValueFromUDFOutput()) {
            YieldableState udfYieldableState = this.tryExecuteUDFOnce();
            if (udfYieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
            }
            if (udfYieldableState != YieldableState.NOT_YIELDABLE_NO_MORE_DATA || this.terminate()) continue;
            return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
        }
        return YieldableState.YIELDABLE;
    }

    @Override
    protected final boolean cacheValue() throws QueryProcessException, IOException {
        while (!this.cacheValueFromUDFOutput()) {
            if (this.executeUDFOnce() || this.terminate()) continue;
            return false;
        }
        return true;
    }

    protected abstract YieldableState tryExecuteUDFOnce() throws Exception;

    protected abstract boolean executeUDFOnce() throws QueryProcessException, IOException;

    protected final boolean cacheValueFromUDFOutput() throws QueryProcessException, IOException {
        if (!this.layerPointReader.next()) {
            return false;
        }
        this.cachedTime = this.layerPointReader.currentTime();
        if (this.layerPointReader.isCurrentNull()) {
            this.currentNull = true;
        } else {
            switch (this.tsDataType) {
                case INT32: {
                    this.cachedInt = this.layerPointReader.currentInt();
                    break;
                }
                case INT64: {
                    this.cachedLong = this.layerPointReader.currentLong();
                    break;
                }
                case FLOAT: {
                    this.cachedFloat = this.layerPointReader.currentFloat();
                    break;
                }
                case DOUBLE: {
                    this.cachedDouble = this.layerPointReader.currentDouble();
                    break;
                }
                case BOOLEAN: {
                    this.cachedBoolean = this.layerPointReader.currentBoolean();
                    break;
                }
                case TEXT: {
                    this.cachedBinary = this.layerPointReader.currentBinary();
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(this.tsDataType.toString());
                }
            }
        }
        this.layerPointReader.readyForNext();
        return true;
    }

    @Override
    public final boolean isConstantPointReader() {
        return this.isLayerPointReaderConstant;
    }
}

