/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.scheduler;

import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.scheduler.AsyncSendPlanNodeHandler;
import org.apache.iotdb.db.mpp.plan.scheduler.FragInstanceDispatchResult;
import org.apache.iotdb.mpp.rpc.thrift.TPlanNode;
import org.apache.iotdb.mpp.rpc.thrift.TSendBatchPlanNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendSinglePlanNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendSinglePlanNodeResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPlanNodeSender {
    private static final Logger logger = LoggerFactory.getLogger(AsyncPlanNodeSender.class);
    private final IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager;
    private final List<FragmentInstance> instances;
    private final Map<TEndPoint, BatchRequestWithIndex> batchRequests;
    private final Map<Integer, TSendSinglePlanNodeResp> instanceId2RespMap;
    private final AtomicLong pendingNumber;
    private final long startSendTime = System.nanoTime();

    public AsyncPlanNodeSender(IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager, List<FragmentInstance> instances) {
        this.asyncInternalServiceClientManager = asyncInternalServiceClientManager;
        this.instances = instances;
        this.batchRequests = new HashMap<TEndPoint, BatchRequestWithIndex>();
        for (int i = 0; i < instances.size(); ++i) {
            this.batchRequests.computeIfAbsent(instances.get(i).getHostDataNode().getInternalEndPoint(), x -> new BatchRequestWithIndex()).addSinglePlanNodeReq(i, new TSendSinglePlanNodeReq(new TPlanNode(instances.get(i).getFragment().getPlanNodeTree().serializeToByteBuffer()), instances.get(i).getRegionReplicaSet().getRegionId()));
        }
        this.instanceId2RespMap = new ConcurrentHashMap<Integer, TSendSinglePlanNodeResp>(instances.size() + 1, 1.0f);
        this.pendingNumber = new AtomicLong(this.batchRequests.keySet().size());
    }

    public void sendAll() {
        for (Map.Entry<TEndPoint, BatchRequestWithIndex> entry : this.batchRequests.entrySet()) {
            AsyncSendPlanNodeHandler handler = new AsyncSendPlanNodeHandler(entry.getValue().getIndexes(), this.pendingNumber, this.instanceId2RespMap, this.startSendTime);
            try {
                AsyncDataNodeInternalServiceClient client = (AsyncDataNodeInternalServiceClient)this.asyncInternalServiceClientManager.borrowClient((Object)entry.getKey());
                client.sendBatchPlanNode(entry.getValue().getBatchRequest(), (AsyncMethodCallback)handler);
            }
            catch (Exception e) {
                handler.onError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilCompleted() throws InterruptedException {
        AtomicLong atomicLong = this.pendingNumber;
        synchronized (atomicLong) {
            while (this.pendingNumber.get() != 0L) {
                this.pendingNumber.wait();
            }
        }
    }

    public List<TSStatus> getFailureStatusList() {
        ArrayList<TSStatus> failureStatusList = new ArrayList<TSStatus>();
        for (Map.Entry<Integer, TSendSinglePlanNodeResp> entry : this.instanceId2RespMap.entrySet()) {
            TSStatus status = entry.getValue().getStatus();
            if (!entry.getValue().accepted) {
                if (status == null) {
                    logger.warn("dispatch write failed. message: {}, node {}", (Object)entry.getValue().message, (Object)this.instances.get(entry.getKey()).getHostDataNode().getInternalEndPoint());
                    failureStatusList.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_ERROR, (String)entry.getValue().getMessage()));
                    continue;
                }
                logger.warn("dispatch write failed. status: {}, code: {}, message: {}, node {}", new Object[]{entry.getValue().status, TSStatusCode.representOf((int)status.code), entry.getValue().message, this.instances.get(entry.getKey()).getHostDataNode().getInternalEndPoint()});
                failureStatusList.add(status);
                continue;
            }
            if (status == null || status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            failureStatusList.add(status);
        }
        return failureStatusList;
    }

    public Future<FragInstanceDispatchResult> getResult() {
        for (Map.Entry<Integer, TSendSinglePlanNodeResp> entry : this.instanceId2RespMap.entrySet()) {
            if (entry.getValue().accepted) continue;
            logger.warn("dispatch write failed. status: {}, code: {}, message: {}, node {}", new Object[]{entry.getValue().status, TSStatusCode.representOf((int)entry.getValue().status.code), entry.getValue().message, this.instances.get(entry.getKey()).getHostDataNode().getInternalEndPoint()});
            if (entry.getValue().getStatus() == null) {
                return Futures.immediateFuture((Object)new FragInstanceDispatchResult(RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_ERROR, (String)entry.getValue().getMessage())));
            }
            return Futures.immediateFuture((Object)new FragInstanceDispatchResult(entry.getValue().getStatus()));
        }
        return Futures.immediateFuture((Object)new FragInstanceDispatchResult(true));
    }

    static class BatchRequestWithIndex {
        private final List<Integer> indexes = new ArrayList<Integer>();
        private final TSendBatchPlanNodeReq batchRequest = new TSendBatchPlanNodeReq();

        BatchRequestWithIndex() {
        }

        void addSinglePlanNodeReq(int index, TSendSinglePlanNodeReq singleRequest) {
            this.indexes.add(index);
            this.batchRequest.addToRequests(singleRequest);
        }

        public List<Integer> getIndexes() {
            return this.indexes;
        }

        public TSendBatchPlanNodeReq getBatchRequest() {
            return this.batchRequest;
        }
    }
}

