/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CrossSeriesAggregationDescriptor
extends AggregationDescriptor {
    private final Expression outputExpression;
    private final int expressionNumOfOneInput;

    public CrossSeriesAggregationDescriptor(String aggregationFuncName, AggregationStep step, List<Expression> inputExpressions, int numberOfInput, Map<String, String> inputAttributes, Expression outputExpression) {
        super(aggregationFuncName, step, inputExpressions, inputAttributes);
        this.outputExpression = outputExpression;
        this.expressionNumOfOneInput = inputExpressions.size() / numberOfInput;
    }

    public CrossSeriesAggregationDescriptor(String aggregationFuncName, AggregationStep step, List<Expression> inputExpressions, Map<String, String> inputAttributes, Expression outputExpression) {
        super(aggregationFuncName, step, inputExpressions, inputAttributes);
        this.outputExpression = outputExpression;
        this.expressionNumOfOneInput = 1;
    }

    public CrossSeriesAggregationDescriptor(AggregationDescriptor aggregationDescriptor, Expression outputExpression, int expressionNumOfOneInput) {
        super(aggregationDescriptor);
        this.outputExpression = outputExpression;
        this.expressionNumOfOneInput = expressionNumOfOneInput;
    }

    public Expression getOutputExpression() {
        return this.outputExpression;
    }

    @Override
    protected String getParametersString() {
        if (this.parametersString == null) {
            StringBuilder builder = new StringBuilder(this.outputExpression.getExpressionString());
            for (int i = 1; i < this.expressionNumOfOneInput; ++i) {
                builder.append(", ").append(((Expression)this.inputExpressions.get(i)).getExpressionString());
            }
            this.appendAttributes(builder);
            this.parametersString = builder.toString();
        }
        return this.parametersString;
    }

    @Override
    public List<List<String>> getInputColumnNamesList() {
        if (this.step.isInputRaw()) {
            return Collections.singletonList(Collections.singletonList(((Expression)this.inputExpressions.get(0)).getExpressionString()));
        }
        ArrayList<List<String>> inputColumnNamesList = new ArrayList<List<String>>();
        Expression[] expressions = new Expression[this.expressionNumOfOneInput];
        for (int i = 0; i < this.inputExpressions.size(); i += this.expressionNumOfOneInput) {
            for (int j = 0; j < this.expressionNumOfOneInput; ++j) {
                expressions[j] = (Expression)this.inputExpressions.get(i + j);
            }
            inputColumnNamesList.add(this.getInputColumnNames(expressions));
        }
        return inputColumnNamesList;
    }

    private List<String> getInputColumnNames(Expression[] expressions) {
        List<String> inputAggregationNames = this.getActualAggregationNames(this.step.isInputPartial());
        ArrayList<String> inputColumnNames = new ArrayList<String>();
        for (String funcName : inputAggregationNames) {
            inputColumnNames.add(funcName + "(" + this.getInputString(expressions) + ")");
        }
        return inputColumnNames;
    }

    private String getInputString(Expression[] expressions) {
        StringBuilder builder = new StringBuilder();
        if (expressions.length != 0) {
            builder.append(expressions[0].getExpressionString());
            for (int i = 1; i < expressions.length; ++i) {
                builder.append(", ").append(expressions[i].getExpressionString());
            }
        }
        this.appendAttributes(builder);
        return builder.toString();
    }

    @Override
    public CrossSeriesAggregationDescriptor deepClone() {
        return new CrossSeriesAggregationDescriptor(this, this.outputExpression, this.expressionNumOfOneInput);
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        Expression.serialize(this.outputExpression, byteBuffer);
        ReadWriteIOUtils.write((int)this.expressionNumOfOneInput, (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        Expression.serialize(this.outputExpression, stream);
        ReadWriteIOUtils.write((int)this.expressionNumOfOneInput, (OutputStream)stream);
    }

    public static CrossSeriesAggregationDescriptor deserialize(ByteBuffer byteBuffer) {
        AggregationDescriptor aggregationDescriptor = AggregationDescriptor.deserialize(byteBuffer);
        Expression outputExpression = Expression.deserialize(byteBuffer);
        int expressionNumOfOneInput = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        return new CrossSeriesAggregationDescriptor(aggregationDescriptor, outputExpression, expressionNumOfOneInput);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CrossSeriesAggregationDescriptor that = (CrossSeriesAggregationDescriptor)o;
        return Objects.equals(this.outputExpression, that.outputExpression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.outputExpression);
    }
}

