/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.binary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.mpp.common.NodeRef;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class BinaryExpression
extends Expression {
    protected Expression leftExpression;
    protected Expression rightExpression;

    protected BinaryExpression(Expression leftExpression, Expression rightExpression) {
        this.leftExpression = leftExpression;
        this.rightExpression = rightExpression;
    }

    protected BinaryExpression(ByteBuffer byteBuffer) {
        this.leftExpression = Expression.deserialize(byteBuffer);
        this.rightExpression = Expression.deserialize(byteBuffer);
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitBinaryExpression(this, context);
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public void setLeftExpression(Expression leftExpression) {
        this.leftExpression = leftExpression;
    }

    public void setRightExpression(Expression rightExpression) {
        this.rightExpression = rightExpression;
    }

    @Override
    public boolean isConstantOperandInternal() {
        return this.leftExpression.isConstantOperand() && this.rightExpression.isConstantOperand();
    }

    @Override
    public List<Expression> getExpressions() {
        return Arrays.asList(this.leftExpression, this.rightExpression);
    }

    @Override
    public void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
        this.leftExpression.constructUdfExecutors(expressionName2Executor, zoneId);
        this.rightExpression.constructUdfExecutors(expressionName2Executor, zoneId);
    }

    @Override
    public final void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
        this.leftExpression.bindInputLayerColumnIndexWithExpression(inputLocations);
        this.rightExpression.bindInputLayerColumnIndexWithExpression(inputLocations);
        String digest = this.getExpressionString();
        if (inputLocations.containsKey(digest)) {
            this.inputColumnIndex = inputLocations.get(digest).get(0).getValueColumnIndex();
        }
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        this.leftExpression.updateStatisticsForMemoryAssigner(memoryAssigner);
        this.rightExpression.updateStatisticsForMemoryAssigner(memoryAssigner);
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    public boolean isMappable(Map<NodeRef<Expression>, TSDataType> expressionTypes) {
        return this.leftExpression.isMappable(expressionTypes) && this.rightExpression.isMappable(expressionTypes);
    }

    @Override
    public String getExpressionStringInternal() {
        StringBuilder builder = new StringBuilder();
        if (this.leftExpression.getExpressionType().getPriority() < this.getExpressionType().getPriority()) {
            builder.append("(").append(this.leftExpression.getExpressionString()).append(")");
        } else {
            builder.append(this.leftExpression.getExpressionString());
        }
        builder.append(" ").append(this.operator()).append(" ");
        if (this.rightExpression.getExpressionType().getPriority() < this.getExpressionType().getPriority()) {
            builder.append("(").append(this.rightExpression.getExpressionString()).append(")");
        } else {
            builder.append(this.rightExpression.getExpressionString());
        }
        return builder.toString();
    }

    protected abstract String operator();

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        Expression.serialize(this.leftExpression, byteBuffer);
        Expression.serialize(this.rightExpression, byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.leftExpression, stream);
        Expression.serialize(this.rightExpression, stream);
    }

    @Override
    public String getOutputSymbolInternal() {
        String left = this.getLeftExpression().getOutputSymbol();
        String right = this.getRightExpression().getOutputSymbol();
        StringBuilder builder = new StringBuilder();
        if (this.leftExpression.getExpressionType().getPriority() < this.getExpressionType().getPriority()) {
            builder.append("(").append(left).append(")");
        } else {
            builder.append(left);
        }
        builder.append(" ").append(this.operator()).append(" ");
        if (this.rightExpression.getExpressionType().getPriority() < this.getExpressionType().getPriority()) {
            builder.append("(").append(right).append(")");
        } else {
            builder.append(right);
        }
        return builder.toString();
    }
}

