/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.NodeRef;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.DeviceViewIntoPathDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.FillDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByParameter;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.IntoPathDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.mpp.plan.statement.component.SortItem;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.ShowQueriesStatement;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;

public class Analysis {
    private Statement statement;
    private QueryType queryType;
    private DataPartition dataPartition;
    private SchemaPartition schemaPartition;
    private ISchemaTree schemaTree;
    private List<TEndPoint> redirectNodeList;
    private final Map<NodeRef<Expression>, TSDataType> expressionTypes = new LinkedHashMap<NodeRef<Expression>, TSDataType>();
    private boolean finishQueryAfterAnalyze = false;
    private TSStatus failStatus;
    private Set<Expression> sourceExpressions;
    private Set<Expression> sourceTransformExpressions;
    private Expression whereExpression;
    private Expression groupByExpression;
    private Set<Expression> aggregationExpressions;
    private LinkedHashMap<Expression, Set<Expression>> crossGroupByExpressions;
    private List<String> tagKeys;
    private Map<List<String>, LinkedHashMap<Expression, List<Expression>>> tagValuesToGroupedTimeseriesOperands;
    private Map<String, Set<Expression>> deviceToSourceExpressions;
    private Map<String, Set<Expression>> deviceToSourceTransformExpressions;
    private Map<String, Expression> deviceToWhereExpression;
    private Map<String, Set<Expression>> deviceToAggregationExpressions;
    private Map<String, Set<Expression>> deviceToSelectExpressions;
    private Map<String, Expression> deviceToGroupByExpression;
    private Map<String, Set<Expression>> deviceToOrderByExpressions;
    private Map<String, List<SortItem>> deviceToSortItems;
    private Map<String, List<Integer>> deviceViewInputIndexesMap;
    private Set<Expression> deviceViewOutputExpressions;
    private boolean deviceViewSpecialProcess;
    private boolean hasValueFilter = false;
    private Filter globalTimeFilter;
    private Set<Expression> selectExpressions;
    private Expression havingExpression;
    private Set<Expression> orderByExpressions;
    private boolean hasSort = false;
    private FillDescriptor fillDescriptor;
    private GroupByTimeParameter groupByTimeParameter;
    private GroupByParameter groupByParameter;
    private OrderByParameter mergeOrderParameter;
    private Ordering timeseriesOrderingForLastQuery = null;
    private DatasetHeader respDatasetHeader;
    private boolean isVirtualSource = false;
    private DeviceViewIntoPathDescriptor deviceViewIntoPathDescriptor;
    private IntoPathDescriptor intoPathDescriptor;
    private Set<TSchemaNode> matchedNodes;
    private Pair<Template, List<PartialPath>> templateSetInfo;
    private Map<PartialPath, Pair<Template, PartialPath>> deviceTemplateSetInfoMap;
    private Map<Integer, Template> relatedTemplateInfo;
    private List<PartialPath> specifiedTemplateRelatedPathPatternList;
    private boolean useLogicalView = false;
    private List<Pair<Expression, String>> outputExpressions = null;
    private List<TDataNodeLocation> runningDataNodeLocations;

    public List<TRegionReplicaSet> getPartitionInfo(PartialPath seriesPath, Filter timefilter) {
        return this.dataPartition.getDataRegionReplicaSet(seriesPath.getDevice(), null);
    }

    public List<TRegionReplicaSet> getPartitionInfo(String deviceName, Filter globalTimeFilter) {
        return this.dataPartition.getDataRegionReplicaSet(deviceName, null);
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public DataPartition getDataPartitionInfo() {
        return this.dataPartition;
    }

    public void setDataPartitionInfo(DataPartition dataPartition) {
        this.dataPartition = dataPartition;
    }

    public SchemaPartition getSchemaPartitionInfo() {
        return this.schemaPartition;
    }

    public void setSchemaPartitionInfo(SchemaPartition schemaPartition) {
        this.schemaPartition = schemaPartition;
    }

    public ISchemaTree getSchemaTree() {
        return this.schemaTree;
    }

    public void setSchemaTree(ISchemaTree schemaTree) {
        this.schemaTree = schemaTree;
    }

    public List<TEndPoint> getRedirectNodeList() {
        return this.redirectNodeList;
    }

    public void setRedirectNodeList(List<TEndPoint> redirectNodeList) {
        this.redirectNodeList = redirectNodeList;
    }

    public void addEndPointToRedirectNodeList(TEndPoint endPoint) {
        if (this.redirectNodeList == null) {
            this.redirectNodeList = new ArrayList<TEndPoint>();
        }
        this.redirectNodeList.add(endPoint);
    }

    public Filter getGlobalTimeFilter() {
        return this.globalTimeFilter;
    }

    public void setGlobalTimeFilter(Filter timeFilter) {
        this.globalTimeFilter = timeFilter;
    }

    public DatasetHeader getRespDatasetHeader() {
        return this.respDatasetHeader;
    }

    public void setRespDatasetHeader(DatasetHeader respDatasetHeader) {
        this.respDatasetHeader = respDatasetHeader;
    }

    public TSDataType getType(Expression expression) {
        if (expression.getExpressionType() == ExpressionType.NULL) {
            return null;
        }
        TSDataType type = this.expressionTypes.get(NodeRef.of(expression));
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Expression not analyzed: %s", (Object)expression);
        return type;
    }

    public boolean hasDataSource() {
        return this.dataPartition != null && !this.dataPartition.isEmpty() || this.schemaPartition != null && !this.schemaPartition.isEmpty() || this.statement instanceof ShowQueriesStatement || this.statement instanceof QueryStatement && ((QueryStatement)this.statement).isAggregationQuery();
    }

    public LinkedHashMap<Expression, Set<Expression>> getCrossGroupByExpressions() {
        return this.crossGroupByExpressions;
    }

    public void setCrossGroupByExpressions(LinkedHashMap<Expression, Set<Expression>> crossGroupByExpressions) {
        this.crossGroupByExpressions = crossGroupByExpressions;
    }

    public FillDescriptor getFillDescriptor() {
        return this.fillDescriptor;
    }

    public void setFillDescriptor(FillDescriptor fillDescriptor) {
        this.fillDescriptor = fillDescriptor;
    }

    public boolean hasValueFilter() {
        return this.hasValueFilter;
    }

    public void setHasValueFilter(boolean hasValueFilter) {
        this.hasValueFilter = hasValueFilter;
    }

    public Expression getWhereExpression() {
        return this.whereExpression;
    }

    public void setWhereExpression(Expression whereExpression) {
        this.whereExpression = whereExpression;
    }

    public Map<String, Expression> getDeviceToWhereExpression() {
        return this.deviceToWhereExpression;
    }

    public void setDeviceToWhereExpression(Map<String, Expression> deviceToWhereExpression) {
        this.deviceToWhereExpression = deviceToWhereExpression;
    }

    public GroupByTimeParameter getGroupByTimeParameter() {
        return this.groupByTimeParameter;
    }

    public Expression getHavingExpression() {
        return this.havingExpression;
    }

    public void setHavingExpression(Expression havingExpression) {
        this.havingExpression = havingExpression;
    }

    public void setGroupByTimeParameter(GroupByTimeParameter groupByTimeParameter) {
        this.groupByTimeParameter = groupByTimeParameter;
    }

    public void setGroupByParameter(GroupByParameter groupByParameter) {
        this.groupByParameter = groupByParameter;
    }

    public GroupByParameter getGroupByParameter() {
        return this.groupByParameter;
    }

    public boolean hasGroupByParameter() {
        return this.groupByParameter != null;
    }

    public boolean isFinishQueryAfterAnalyze() {
        return this.finishQueryAfterAnalyze;
    }

    public void setFinishQueryAfterAnalyze(boolean finishQueryAfterAnalyze) {
        this.finishQueryAfterAnalyze = finishQueryAfterAnalyze;
    }

    public boolean isFailed() {
        return this.failStatus != null;
    }

    public TSStatus getFailStatus() {
        return this.failStatus;
    }

    public void setFailStatus(TSStatus status) {
        this.failStatus = status;
    }

    public void setDeviceViewInputIndexesMap(Map<String, List<Integer>> deviceViewInputIndexesMap) {
        this.deviceViewInputIndexesMap = deviceViewInputIndexesMap;
    }

    public Map<String, List<Integer>> getDeviceViewInputIndexesMap() {
        return this.deviceViewInputIndexesMap;
    }

    public Set<Expression> getSourceExpressions() {
        return this.sourceExpressions;
    }

    public void setSourceExpressions(Set<Expression> sourceExpressions) {
        this.sourceExpressions = sourceExpressions;
    }

    public Set<Expression> getSourceTransformExpressions() {
        return this.sourceTransformExpressions;
    }

    public void setSourceTransformExpressions(Set<Expression> sourceTransformExpressions) {
        this.sourceTransformExpressions = sourceTransformExpressions;
    }

    public Set<Expression> getAggregationExpressions() {
        return this.aggregationExpressions;
    }

    public void setAggregationExpressions(Set<Expression> aggregationExpressions) {
        this.aggregationExpressions = aggregationExpressions;
    }

    public Set<Expression> getSelectExpressions() {
        return this.selectExpressions;
    }

    public void setSelectExpressions(Set<Expression> selectExpressions) {
        this.selectExpressions = selectExpressions;
    }

    public Map<String, Set<Expression>> getDeviceToSourceExpressions() {
        return this.deviceToSourceExpressions;
    }

    public void setDeviceToSourceExpressions(Map<String, Set<Expression>> deviceToSourceExpressions) {
        this.deviceToSourceExpressions = deviceToSourceExpressions;
    }

    public Map<String, Set<Expression>> getDeviceToSourceTransformExpressions() {
        return this.deviceToSourceTransformExpressions;
    }

    public void setDeviceToSourceTransformExpressions(Map<String, Set<Expression>> deviceToSourceTransformExpressions) {
        this.deviceToSourceTransformExpressions = deviceToSourceTransformExpressions;
    }

    public Map<String, Set<Expression>> getDeviceToAggregationExpressions() {
        return this.deviceToAggregationExpressions;
    }

    public void setDeviceToAggregationExpressions(Map<String, Set<Expression>> deviceToAggregationExpressions) {
        this.deviceToAggregationExpressions = deviceToAggregationExpressions;
    }

    public Map<String, Set<Expression>> getDeviceToSelectExpressions() {
        return this.deviceToSelectExpressions;
    }

    public void setDeviceToSelectExpressions(Map<String, Set<Expression>> deviceToSelectExpressions) {
        this.deviceToSelectExpressions = deviceToSelectExpressions;
    }

    public Expression getGroupByExpression() {
        return this.groupByExpression;
    }

    public void setGroupByExpression(Expression groupByExpression) {
        this.groupByExpression = groupByExpression;
    }

    public Map<String, Expression> getDeviceToGroupByExpression() {
        return this.deviceToGroupByExpression;
    }

    public void setDeviceToGroupByExpression(Map<String, Expression> deviceToGroupByExpression) {
        this.deviceToGroupByExpression = deviceToGroupByExpression;
    }

    public Set<TSchemaNode> getMatchedNodes() {
        return this.matchedNodes;
    }

    public void setMatchedNodes(Set<TSchemaNode> matchedNodes) {
        this.matchedNodes = matchedNodes;
    }

    public OrderByParameter getMergeOrderParameter() {
        return this.mergeOrderParameter;
    }

    public void setMergeOrderParameter(OrderByParameter mergeOrderParameter) {
        this.mergeOrderParameter = mergeOrderParameter;
    }

    public Pair<Template, List<PartialPath>> getTemplateSetInfo() {
        return this.templateSetInfo;
    }

    public void setTemplateSetInfo(Pair<Template, List<PartialPath>> templateSetInfo) {
        this.templateSetInfo = templateSetInfo;
    }

    public Map<PartialPath, Pair<Template, PartialPath>> getDeviceTemplateSetInfoMap() {
        return this.deviceTemplateSetInfoMap;
    }

    public void setDeviceTemplateSetInfoMap(Map<PartialPath, Pair<Template, PartialPath>> deviceTemplateSetInfoMap) {
        this.deviceTemplateSetInfoMap = deviceTemplateSetInfoMap;
    }

    public Map<Integer, Template> getRelatedTemplateInfo() {
        return this.relatedTemplateInfo;
    }

    public void setRelatedTemplateInfo(Map<Integer, Template> relatedTemplateInfo) {
        this.relatedTemplateInfo = relatedTemplateInfo;
    }

    public List<PartialPath> getSpecifiedTemplateRelatedPathPatternList() {
        return this.specifiedTemplateRelatedPathPatternList;
    }

    public void setSpecifiedTemplateRelatedPathPatternList(List<PartialPath> specifiedTemplateRelatedPathPatternList) {
        this.specifiedTemplateRelatedPathPatternList = specifiedTemplateRelatedPathPatternList;
    }

    public void addTypes(Map<NodeRef<Expression>, TSDataType> types) {
        this.expressionTypes.putAll(types);
    }

    public Set<Expression> getDeviceViewOutputExpressions() {
        return this.deviceViewOutputExpressions;
    }

    public void setDeviceViewOutputExpressions(Set<Expression> deviceViewOutputExpressions) {
        this.deviceViewOutputExpressions = deviceViewOutputExpressions;
    }

    public boolean isDeviceViewSpecialProcess() {
        return this.deviceViewSpecialProcess;
    }

    public void setDeviceViewSpecialProcess(boolean deviceViewSpecialProcess) {
        this.deviceViewSpecialProcess = deviceViewSpecialProcess;
    }

    public DeviceViewIntoPathDescriptor getDeviceViewIntoPathDescriptor() {
        return this.deviceViewIntoPathDescriptor;
    }

    public void setDeviceViewIntoPathDescriptor(DeviceViewIntoPathDescriptor deviceViewIntoPathDescriptor) {
        this.deviceViewIntoPathDescriptor = deviceViewIntoPathDescriptor;
    }

    public IntoPathDescriptor getIntoPathDescriptor() {
        return this.intoPathDescriptor;
    }

    public void setIntoPathDescriptor(IntoPathDescriptor intoPathDescriptor) {
        this.intoPathDescriptor = intoPathDescriptor;
    }

    public List<String> getTagKeys() {
        return this.tagKeys;
    }

    public void setTagKeys(List<String> tagKeys) {
        this.tagKeys = tagKeys;
    }

    public Map<List<String>, LinkedHashMap<Expression, List<Expression>>> getTagValuesToGroupedTimeseriesOperands() {
        return this.tagValuesToGroupedTimeseriesOperands;
    }

    public void setTagValuesToGroupedTimeseriesOperands(Map<List<String>, LinkedHashMap<Expression, List<Expression>>> tagValuesToGroupedTimeseriesOperands) {
        this.tagValuesToGroupedTimeseriesOperands = tagValuesToGroupedTimeseriesOperands;
    }

    public List<TDataNodeLocation> getRunningDataNodeLocations() {
        return this.runningDataNodeLocations;
    }

    public void setRunningDataNodeLocations(List<TDataNodeLocation> runningDataNodeLocations) {
        this.runningDataNodeLocations = runningDataNodeLocations;
    }

    public boolean isVirtualSource() {
        return this.isVirtualSource;
    }

    public void setVirtualSource(boolean virtualSource) {
        this.isVirtualSource = virtualSource;
    }

    public Map<NodeRef<Expression>, TSDataType> getExpressionTypes() {
        return this.expressionTypes;
    }

    public void setOrderByExpressions(Set<Expression> orderByExpressions) {
        this.orderByExpressions = orderByExpressions;
    }

    public Set<Expression> getOrderByExpressions() {
        return this.orderByExpressions;
    }

    public Map<String, Set<Expression>> getDeviceToOrderByExpressions() {
        return this.deviceToOrderByExpressions;
    }

    public void setDeviceToOrderByExpressions(Map<String, Set<Expression>> deviceToOrderByExpressions) {
        this.deviceToOrderByExpressions = deviceToOrderByExpressions;
    }

    public void setHasSort(boolean hasSort) {
        this.hasSort = hasSort;
    }

    public boolean isHasSort() {
        return this.hasSort;
    }

    public Map<String, List<SortItem>> getDeviceToSortItems() {
        return this.deviceToSortItems;
    }

    public void setDeviceToSortItems(Map<String, List<SortItem>> deviceToSortItems) {
        this.deviceToSortItems = deviceToSortItems;
    }

    public void setUseLogicalView(boolean useLogicalView) {
        this.useLogicalView = useLogicalView;
    }

    public boolean useLogicalView() {
        return this.useLogicalView;
    }

    public void setOutputExpressions(List<Pair<Expression, String>> outputExpressions) {
        this.outputExpressions = outputExpressions;
    }

    public List<Pair<Expression, String>> getOutputExpressions() {
        return this.outputExpressions;
    }

    public Ordering getTimeseriesOrderingForLastQuery() {
        return this.timeseriesOrderingForLastQuery;
    }

    public void setTimeseriesOrderingForLastQuery(Ordering timeseriesOrderingForLastQuery) {
        this.timeseriesOrderingForLastQuery = timeseriesOrderingForLastQuery;
    }
}

