/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process.last;

import com.google.common.base.Preconditions;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.db.metadata.cache.DataNodeSchemaCache;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.last.AlignedUpdateLastCacheOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class AlignedUpdateViewPathLastCacheOperator
extends AlignedUpdateLastCacheOperator {
    private final String outputViewPath;

    public AlignedUpdateViewPathLastCacheOperator(OperatorContext operatorContext, Operator child, AlignedPath seriesPath, DataNodeSchemaCache dataNodeSchemaCache, boolean needUpdateCache, String outputViewPath) {
        super(operatorContext, child, seriesPath, dataNodeSchemaCache, needUpdateCache);
        Preconditions.checkArgument((seriesPath.getMeasurementList().size() == 1 ? 1 : 0) != 0);
        this.outputViewPath = outputViewPath;
    }

    @Override
    protected void appendLastValueToTsBlockBuilder(long lastTime, TsPrimitiveType lastValue, MeasurementPath measurementPath) {
        LastQueryUtil.appendLastValue(this.tsBlockBuilder, lastTime, this.outputViewPath, lastValue.getStringValue(), measurementPath.getSeriesType().name());
    }
}

